/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnitRangeImpl;
import org.w3c.dom.Element;

public class DistanceRangeSubsetter
implements SodElement {
    private UnitRangeImpl unitRange;

    public DistanceRangeSubsetter(Element config) throws ConfigurationException {
        this.processConfig(config);
    }

    public void processConfig(Element config) throws ConfigurationException {
        this.unitRange = SodUtil.loadUnitRange(config);
        if (this.unitRange.the_units.isConvertableTo(UnitImpl.KILOMETER)) {
            QuantityImpl min = new QuantityImpl(this.unitRange.getMinValue(), this.unitRange.getUnit());
            QuantityImpl max = new QuantityImpl(this.unitRange.getMaxValue(), this.unitRange.getUnit());
            this.unitRange = new UnitRangeImpl(DistAz.kilometersToDegrees(min.getValue(UnitImpl.KILOMETER)), DistAz.kilometersToDegrees(max.getValue(UnitImpl.KILOMETER)), UnitImpl.DEGREE);
        }
    }

    public UnitRangeImpl getUnitRange() {
        return this.unitRange;
    }

    public QuantityImpl getMin() {
        return new QuantityImpl(this.getUnitRange().min_value, this.getUnitRange().the_units);
    }

    public QuantityImpl getMax() {
        return new QuantityImpl(this.getUnitRange().max_value, this.getUnitRange().the_units);
    }
}

