/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.bag.AreaUtil;
import edu.sc.seis.sod.model.common.Area;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.subsetter.LatitudeRange;
import edu.sc.seis.sod.subsetter.LongitudeRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AreaSubsetter {
    protected Area area = null;
    protected Location[] locationArray;

    public AreaSubsetter(Element config) throws ConfigurationException {
        String fileLocation = DOMHelper.extractText(config, "polygonFile", "");
        if (fileLocation.equals("")) {
            NodeList children = config.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!(node instanceof Element)) continue;
                this.area = (Area)SodUtil.load((Element)node, "");
                break;
            }
        } else {
            this.locationArray = AreaSubsetter.extractPolygon(fileLocation);
        }
    }

    public static Location[] extractPolygon(String fileLocation) throws ConfigurationException {
        Location[] locs;
        try {
            locs = AreaUtil.loadPolygon(AreaSubsetter.makeRelativeOrRecipeDirReader(fileLocation));
        }
        catch (FileNotFoundException e) {
            throw new UserConfigurationException(e.getMessage() + " as a polygon file.");
        }
        catch (IOException e) {
            throw new ConfigurationException("Problem reading from file " + fileLocation, e);
        }
        for (int i = 0; i < locs.length; ++i) {
            LatitudeRange.check(locs[i].latitude, fileLocation);
            LongitudeRange.sanitize(locs[i].longitude, fileLocation);
        }
        return locs;
    }

    public static BufferedReader makeRelativeOrRecipeDirReader(String fileLocation) throws FileNotFoundException {
        FileReader fileInput;
        if ((fileLocation = fileLocation.trim()).contains(":")) {
            try {
                URI uri = new URI(fileLocation);
                if (uri.getScheme() != null && uri.isAbsolute()) {
                    return new BufferedReader(new InputStreamReader(uri.toURL().openStream()));
                }
            }
            catch (URISyntaxException uri) {
            }
            catch (IOException uri) {
                // empty catch block
            }
        }
        File simpleLocation = new File(fileLocation);
        try {
            fileInput = new FileReader(simpleLocation);
        }
        catch (FileNotFoundException e) {
            File inConfigDir = new File(new File(Start.getConfigFileName()).getParentFile(), fileLocation);
            try {
                fileInput = new FileReader(inConfigDir);
            }
            catch (FileNotFoundException e2) {
                throw new FileNotFoundException("Unable to find as URL or '" + String.valueOf(simpleLocation) + "' or '" + String.valueOf(inConfigDir) + "'");
            }
        }
        return new BufferedReader(fileInput);
    }

    public boolean accept(Location loc) {
        if (this.locationArray != null) {
            return AreaUtil.inArea(this.locationArray, loc);
        }
        return AreaUtil.inArea(this.area, loc);
    }
}

