/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.sod.SodUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AbstractEquipmentSubsetter {
    Pattern type;
    Pattern manufacturer;
    Pattern vendor;
    Pattern model;
    Pattern serialNumber;

    public AbstractEquipmentSubsetter() {
    }

    public AbstractEquipmentSubsetter(Element config) {
        this.parseConfig(config);
    }

    protected void parseConfig(Element config) {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element el = (Element)children.item(i);
            String tagName = el.getTagName();
            if (tagName.equals("type")) {
                this.type = Pattern.compile(SodUtil.getNestedText(el));
                continue;
            }
            if (tagName.equals("manufacturer")) {
                this.manufacturer = Pattern.compile(SodUtil.getNestedText(el));
                continue;
            }
            if (tagName.equals("vendor")) {
                this.vendor = Pattern.compile(SodUtil.getNestedText(el));
                continue;
            }
            if (tagName.equals("model")) {
                this.model = Pattern.compile(SodUtil.getNestedText(el));
                continue;
            }
            if (!tagName.equals("serialNumber")) continue;
            this.serialNumber = Pattern.compile(SodUtil.getNestedText(el));
        }
    }

    protected boolean doesMatch(Equipment eq) {
        return this.doesMatch(this.type, eq.getType()) && this.doesMatch(this.manufacturer, eq.getManufacturer()) && this.doesMatch(this.vendor, eq.getVendor()) && this.doesMatch(this.model, eq.getModel()) && this.doesMatch(this.serialNumber, eq.getSerialNumber());
    }

    protected boolean doesMatch(Pattern p, String val) {
        if (p == null) {
            return true;
        }
        Matcher m = p.matcher(val);
        return m.matches();
    }
}

