/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;

public abstract class PeriodicAction {
    private boolean scheduled = false;
    private static final Duration ACTION_INTERVAL = Duration.ofMinutes(2L);
    private static final long ACTION_INTERVAL_MILLIS = ACTION_INTERVAL.toMillis();
    private Instant lastAct = ClockUtil.now().minus(ACTION_INTERVAL);
    private Object schedulingLock = new Object();
    private static Timer t = new Timer();

    public abstract void act();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actIfPeriodElapsed() {
        Object object = this.schedulingLock;
        synchronized (object) {
            if (Duration.between(this.lastAct, ClockUtil.now()).toNanos() > ACTION_INTERVAL.toNanos()) {
                this.actNow();
            } else if (!this.scheduled) {
                t.schedule((TimerTask)new ScheduledActor(), ACTION_INTERVAL_MILLIS);
                this.scheduled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actNow() {
        Object object = this.schedulingLock;
        synchronized (object) {
            this.lastAct = ClockUtil.now();
            this.scheduled = false;
        }
        try {
            this.act();
        }
        catch (Throwable t) {
            GlobalExceptionHandler.handle("Trouble running periodic action", t);
        }
    }

    private class ScheduledActor
    extends TimerTask {
        private ScheduledActor() {
        }

        @Override
        public void run() {
            PeriodicAction.this.actNow();
        }
    }
}

