/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.waveserver.WaveServer;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.RequestFilterUtil;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class WinstonWaveServerSource
implements SeismogramSource {
    private WaveServer ws;

    public WinstonWaveServerSource(WaveServer ws) {
        this.ws = ws;
    }

    public static Instant toDate(double d) {
        return TimeUtils.instantFromEpochSeconds((double)d);
    }

    public static double toEpochSeconds(Instant d) {
        return TimeUtils.instantToEpochSeconds((Instant)d);
    }

    public static double toY2KSeconds(Instant d) {
        return TimeUtils.instantToEpochSeconds((Instant)d) - 9.46728E8;
    }

    public static Instant y2kSecondsToDate(double d) {
        return WinstonWaveServerSource.toDate(d + 9.46728E8);
    }

    @Override
    public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws SeismogramSourceException {
        ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
        for (RequestFilter rf : request) {
            try {
                List traceBufs = this.ws.getTraceBuf(new ChannelTimeWindow(rf.channelId.getNetworkId(), rf.channelId.getStationCode(), rf.channelId.getLocCode(), rf.channelId.getChannelCode(), rf.startTime, rf.endTime));
                if (traceBufs == null) continue;
                for (TraceBuf2 buf : traceBufs) {
                    out.add(WinstonWaveServerSource.toFissures(buf, rf.channelId));
                }
            }
            catch (IOException e) {
                throw new SeismogramSourceException("unable to get TraceBuf from WaveServer(" + this.ws.getHost() + ", " + this.ws.getPort() + ") for " + RequestFilterUtil.toString(rf), e);
            }
        }
        return out;
    }

    public static LocalSeismogramImpl toFissures(TraceBuf2 buf, ChannelId chan) {
        SeismogramAttrImpl seisAttr = new SeismogramAttrImpl("via WaveServer:" + Math.random(), WinstonWaveServerSource.toDate(buf.getStartTime()), buf.getNumSamples(), SamplingImpl.ofSamplesSeconds(1, 1.0 / buf.getSampleRate()), UnitImpl.COUNT, chan);
        if (buf.isShortData()) {
            return new LocalSeismogramImpl(seisAttr, buf.getShortData());
        }
        if (buf.isIntData()) {
            return new LocalSeismogramImpl(seisAttr, buf.getIntData());
        }
        if (buf.isFloatData()) {
            return new LocalSeismogramImpl(seisAttr, buf.getFloatData());
        }
        if (buf.isDoubleData()) {
            return new LocalSeismogramImpl(seisAttr, buf.getDoubleData());
        }
        throw new RuntimeException("Unknwon data type: " + buf.getDataType());
    }
}

