/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.waveserver.WaveServer;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.WinstonWaveServerSource;
import org.w3c.dom.Element;

public class WinstonWaveServer
implements SeismogramSourceLocator,
SodElement {
    private WaveServer ws;
    String host;
    int port;

    public WinstonWaveServer(Element config) {
        this(config, "eeyore.seis.sc.edu");
    }

    public WinstonWaveServer(Element config, String defaultHost) {
        this.host = SodUtil.loadText(config, "host", defaultHost);
        this.port = SodUtil.loadInt(config, "port", 16022);
    }

    public WinstonWaveServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public SeismogramSource getSeismogramSource(CacheEvent event, Channel channel, RequestFilter[] infilters, MeasurementStorage cookieJar) throws Exception {
        return new WinstonWaveServerSource(this.getWaveServer());
    }

    public WaveServer getWaveServer() {
        if (this.ws == null) {
            this.ws = new WaveServer(this.host, this.port);
        }
        return this.ws;
    }
}

