/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.sc.seis.sod.bag.Cut;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromiseSeismogramList {
    SeismogramSourceException seismogramSourceException;
    List<LocalSeismogramImpl> matching;
    List<RequestFilter> request;
    private static final Logger logger = LoggerFactory.getLogger(PromiseSeismogramList.class);

    PromiseSeismogramList(List<RequestFilter> request) {
        this.request = request;
    }

    public List<RequestFilter> getRequest() {
        return this.request;
    }

    public synchronized List<LocalSeismogramImpl> getResult() throws SeismogramSourceException {
        while (this.matching == null && this.seismogramSourceException == null) {
            try {
                this.notifyAll();
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.seismogramSourceException != null) {
            throw this.seismogramSourceException;
        }
        return this.matching;
    }

    synchronized void finishRequest(List<LocalSeismogramImpl> seisList) throws SeismogramSourceException {
        try {
            this.matching = new ArrayList<LocalSeismogramImpl>();
            block2: for (LocalSeismogramImpl seis : seisList) {
                for (RequestFilter rf : this.request) {
                    TimeRange seisRange;
                    TimeRange rfRange;
                    if (!ChannelIdUtil.areEqualExceptForBeginTime(rf.channelId, seis.getChannelID()) || !(rfRange = new TimeRange(rf)).intersects(seisRange = new TimeRange(seis))) continue;
                    Cut c = new Cut(rf);
                    LocalSeismogramImpl cutSeis = c.applyEncoded(seis);
                    cutSeis.channel_id = rf.getChannelId();
                    this.matching.add(cutSeis);
                    continue block2;
                }
            }
            this.notifyAll();
        }
        catch (FissuresException e) {
            throw new SeismogramSourceException(e);
        }
    }

    synchronized void seismogramSourceException(SeismogramSourceException e) {
        this.seismogramSourceException = e;
        this.notifyAll();
    }
}

