/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DataRecordIterator;
import edu.sc.seis.sod.BuildVersion;
import edu.sc.seis.sod.RunProperties;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.source.network.FdsnStation;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import edu.sc.seis.sod.source.seismogram.ConstantSeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.SeismogramAuthorizationException;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.util.convert.mseed.FissuresConvert;
import edu.sc.seis.sod.util.time.RangeTool;
import edu.sc.seis.sod.util.time.ReduceTool;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FdsnDataSelect
extends ConstantSeismogramSourceLocator
implements SeismogramSourceLocator {
    private FDSNDataSelectQueryParams queryParams = new FDSNDataSelectQueryParams();
    private int timeoutMillis = 10000;
    FdsnStation fdsnStation = null;
    private String username;
    private String password;
    private String realm;
    private int queryCount = 0;
    private int authFailCount = 0;
    public static final String IRIS_REALM = "IRIS";
    public static final String BAD_AUTH_MESSAGE = "The remote web service just indicated that the query was not authorized. This may be because your username, password is wrong, the service does not support authentication or it could be a bug in SOD. Check your recipe and if you cannot figure it out contact the developers at sod@seis.sc.edu. ";
    private static final Logger logger = LoggerFactory.getLogger(FdsnDataSelect.class);

    public FdsnDataSelect() {
        super("DefaultFDSNDataSelect");
        this.timeoutMillis = 10000;
        this.username = "";
        this.password = "";
        this.realm = "";
        this.checkFdsnStationLinkage();
    }

    public FdsnDataSelect(Element config) throws MalformedURLException, URISyntaxException {
        this(config, "service.iris.edu");
    }

    public FdsnDataSelect(Element config, String defaultHost) throws MalformedURLException, URISyntaxException {
        super(config, "DefaultFDSNDataSelect", 2);
        String fdsnwsPath;
        String scheme;
        String host;
        int port = SodUtil.loadInt(config, "port", -1);
        if (port > 0) {
            this.queryParams.setPort(port);
        }
        if ((host = SodUtil.loadText(config, "host", defaultHost)) != null && host.length() != 0) {
            this.queryParams.setHost(host);
        }
        if ((scheme = SodUtil.loadText(config, "scheme", null)) != null && scheme.length() != 0) {
            this.queryParams.setScheme(scheme);
            if (port == -1) {
                if (scheme.equalsIgnoreCase("http")) {
                    this.queryParams.setPort(80);
                }
                if (scheme.equalsIgnoreCase("https")) {
                    this.queryParams.setPort(443);
                }
            }
        }
        if ((fdsnwsPath = SodUtil.loadText(config, "fdsnwsPath", null)) != null && fdsnwsPath.length() != 0) {
            this.queryParams.setFdsnwsPath(fdsnwsPath);
        }
        this.username = SodUtil.loadText(config, "user", "");
        this.password = SodUtil.loadText(config, "password", "");
        this.realm = SodUtil.loadText(config, "realm", null);
        this.timeoutMillis = 1000 * SodUtil.loadInt(config, "timeoutSecs", 10);
        this.checkFdsnStationLinkage();
    }

    private void checkFdsnStationLinkage() {
        NetworkSource wrappedNetSource = (WrappingNetworkSource)Start.getNetworkArm().getNetworkSource();
        while (wrappedNetSource instanceof WrappingNetworkSource) {
            wrappedNetSource = ((WrappingNetworkSource)wrappedNetSource).getWrapped();
        }
        if (wrappedNetSource instanceof FdsnStation) {
            this.fdsnStation = (FdsnStation)wrappedNetSource;
        } else {
            logger.warn("Can't do FdsnStation Linkage, net source no FdsnStation: " + wrappedNetSource.getClass().getCanonicalName());
        }
        if (this.username != null && !this.username.equals("") && this.password != null && Start.getNetworkArm() != null) {
            logger.info("User and password set, so including restricted in FdsnStation network source");
            this.fdsnStation.includeRestricted(true);
        }
    }

    public FdsnDataSelect(String host, int port) {
        super(host, 2);
        this.queryParams.setHost(host);
        this.queryParams.setPort(port);
    }

    @Override
    public SeismogramSource getSeismogramSource() {
        return new SeismogramSource(){

            @Override
            public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws SeismogramSourceException {
                int count = 0;
                SeismogramSourceException latest = null;
                while (count == 0 || FdsnDataSelect.this.getRetryStrategy().shouldRetry(latest, this, count++)) {
                    try {
                        List<LocalSeismogramImpl> result = this.internalRetrieveData(request);
                        FdsnDataSelect.this.getRetryStrategy().serverRecovered(this);
                        return result;
                    }
                    catch (SeismogramSourceException t) {
                        latest = t;
                        Throwable rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)t);
                        if (t instanceof SeismogramAuthorizationException) {
                            throw t;
                        }
                        if (t.getCause() == null) {
                            throw t;
                        }
                        if (rootCause instanceof IOException || t.getCause() instanceof FDSNWSException && ((FDSNWSException)t.getCause()).getHttpResponseCode() != 200 && ((FDSNWSException)t.getCause()).getHttpResponseCode() != 401) continue;
                        throw t;
                    }
                    catch (OutOfMemoryError e) {
                        throw new RuntimeException("Out of memory", e);
                    }
                }
                throw latest;
            }

            public List<LocalSeismogramImpl> internalRetrieveData(List<RequestFilter> request) throws SeismogramSourceException {
                ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
                if (request.size() != 0) {
                    FDSNDataSelectQueryParams newQueryParams = FdsnDataSelect.this.queryParams.clone();
                    ArrayList<ChannelTimeWindow> queryRequest = new ArrayList<ChannelTimeWindow>();
                    for (RequestFilter rf : request) {
                        ChannelId c = rf.channelId;
                        queryRequest.add(new ChannelTimeWindow(c.getNetworkCode(), c.getStationCode(), c.getLocCode(), c.getChannelCode(), rf.startTime, rf.endTime));
                    }
                    List<DataRecord> drList = this.retrieveData(newQueryParams, queryRequest, FdsnDataSelect.this.getRetries());
                    try {
                        List<LocalSeismogramImpl> perRFList = FissuresConvert.toFissures(drList);
                        perRFList = Arrays.asList(ReduceTool.merge(perRFList.toArray(new LocalSeismogramImpl[0])));
                        block4: for (LocalSeismogramImpl seis : perRFList) {
                            for (RequestFilter rf : request) {
                                if (!RangeTool.seisPartOfRequest(rf, seis)) continue;
                                seis.channel_id = rf.getChannelId();
                                continue block4;
                            }
                        }
                        out.addAll(perRFList);
                    }
                    catch (SeisFileException e) {
                        throw new SeismogramSourceException(e);
                    }
                    catch (FissuresException e) {
                        throw new SeismogramSourceException(e);
                    }
                }
                return out;
            }

            public List<DataRecord> retrieveData(FDSNDataSelectQueryParams queryParams, List<ChannelTimeWindow> queryRequest, int tryCount) throws SeismogramSourceException {
                ArrayList<DataRecord> drList = new ArrayList<DataRecord>();
                FDSNDataSelectQuerier querier = new FDSNDataSelectQuerier(queryParams, queryRequest);
                RunProperties runProps = Start.getRunProps();
                if (runProps.getProxyHost() != null) {
                    querier.setProxyHost(runProps.getProxyHost());
                    querier.setProxyPort(runProps.getProxyPort());
                    querier.setProxyProtocol(runProps.getProxyScheme());
                }
                querier.setConnectTimeout(FdsnDataSelect.this.timeoutMillis);
                querier.setReadTimeout(FdsnDataSelect.this.timeoutMillis);
                Object restrictedStr = "query: ";
                if (FdsnDataSelect.this.username != null && FdsnDataSelect.this.username.length() != 0 && FdsnDataSelect.this.password != null && FdsnDataSelect.this.password.length() != 0) {
                    querier.enableRestrictedData(FdsnDataSelect.this.username, FdsnDataSelect.this.password, FdsnDataSelect.this.realm);
                    restrictedStr = "restricted " + (String)restrictedStr;
                }
                try {
                    logger.info((String)restrictedStr + String.valueOf(querier.formURIForPost()));
                }
                catch (URISyntaxException e) {
                    throw new SeismogramSourceException("Error with URL syntax", e);
                }
                querier.setUserAgent("SOD/" + BuildVersion.getVersion());
                try {
                    DataRecordIterator drIt = querier.getDataRecordIterator();
                    while (drIt.hasNext()) {
                        drList.add(drIt.next());
                    }
                    ++FdsnDataSelect.this.queryCount;
                }
                catch (FDSNWSException e) {
                    if (querier.getResponseCode() == 401 || querier.getResponseCode() == 403) {
                        if (FdsnDataSelect.this.queryCount < 3 && FdsnDataSelect.this.authFailCount != 0) {
                            Start.simpleArmFailure(Start.getWaveformArmArray()[0], "The remote web service just indicated that the query was not authorized. This may be because your username, password is wrong, the service does not support authentication or it could be a bug in SOD. Check your recipe and if you cannot figure it out contact the developers at sod@seis.sc.edu.  " + querier.getResponseCode() + "     " + e.getMessage() + " on " + String.valueOf(e.getTargetURI()));
                            throw new SeismogramAuthorizationException("Authorization failure to " + String.valueOf(e.getTargetURI()), e);
                        }
                        ++FdsnDataSelect.this.authFailCount;
                        logger.info(FdsnDataSelect.this.authFailCount + " Authentication failures, but will trying " + --tryCount + " more times: " + querier.getResponseCode() + " " + String.valueOf(e.getTargetURI()));
                        if (tryCount > 0) {
                            List<DataRecord> list = this.retrieveData(queryParams, queryRequest, tryCount);
                            return list;
                        }
                        throw new SeismogramSourceException("Auth fail retries exceeded", e);
                    }
                    if (querier.getResponseCode() == 400) {
                        Start.simpleArmFailure(Start.getWaveformArmArray()[0], "The remote web service just indicated that the query was badly formed. This may be because it does not support all of the parameters that SOD uses or it could be a bug in SOD. Check your recipe and if you cannot figure it out contact the developers at sod@seis.sc.edu.  " + e.getMessage() + " on " + String.valueOf(e.getTargetURI()));
                        throw new SeismogramSourceException(e);
                    }
                    throw new SeismogramSourceException(e);
                }
                catch (SeisFileException e) {
                    throw new SeismogramSourceException(e);
                }
                catch (SocketTimeoutException e) {
                    logger.info("Timeout, will retry " + --tryCount + " more times");
                    if (tryCount > 0) {
                        List<DataRecord> list = this.retrieveData(queryParams, queryRequest, tryCount);
                        return list;
                    }
                    throw new SeismogramSourceException("Retries exceeded", e);
                }
                catch (IOException e) {
                    throw new SeismogramSourceException(e);
                }
                finally {
                    querier.close();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found " + drList.size() + " data records.");
                }
                return drList;
            }
        };
    }
}

