/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelLogicalSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.origin.OriginTimeRange;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChoiceSourceItem
implements EventChannelSubsetter,
SeismogramSourceLocator {
    SeismogramSourceLocator locator;
    EventChannelSubsetter eventChannelSubsetter;

    public ChoiceSourceItem(Element config) throws ConfigurationException {
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            Node node = childNodes.item(counter);
            if (!(node instanceof Element)) continue;
            SodElement sodElement = (SodElement)SodUtil.load((Element)node, new String[]{"seismogram", "eventChannel", "eventStation", "channel", "station", "network", "origin"});
            if (sodElement instanceof SeismogramSourceLocator) {
                this.locator = (SeismogramSourceLocator)sodElement;
                continue;
            }
            this.eventChannelSubsetter = EventChannelLogicalSubsetter.createSubsetter((Subsetter)sodElement);
        }
    }

    public ChoiceSourceItem(OriginTimeRange subsetter, SeismogramSourceLocator source) throws ConfigurationException {
        this.eventChannelSubsetter = EventChannelLogicalSubsetter.createSubsetter(subsetter);
        this.locator = source;
    }

    @Override
    public SeismogramSource getSeismogramSource(CacheEvent event, Channel channel, RequestFilter[] infilters, MeasurementStorage cookieJar) throws Exception {
        return this.locator.getSeismogramSource(event, channel, infilters, cookieJar);
    }

    @Override
    public StringTree accept(CacheEvent event, Channel channel, MeasurementStorage cookieJar) throws Exception {
        return this.eventChannelSubsetter.accept(event, channel, cookieJar);
    }
}

