/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.source.seismogram.ChoiceSourceItem;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChoiceSource
implements SeismogramSourceLocator {
    private List<ChoiceSourceItem> choices = new ArrayList<ChoiceSourceItem>();
    private SeismogramSourceLocator otherwise;

    public ChoiceSource(List<ChoiceSourceItem> choices, SeismogramSourceLocator otherwise) {
        this.choices = choices;
        this.otherwise = otherwise;
    }

    public ChoiceSource(Element config) throws ConfigurationException {
        try {
            NodeList choiceNodes = DOMHelper.extractNodes(config, "choice");
            for (int i = 0; i < choiceNodes.getLength(); ++i) {
                this.choices.add(new ChoiceSourceItem((Element)choiceNodes.item(i)));
            }
            Element otherwiseEl = DOMHelper.extractElement(config, "otherwise/*");
            this.otherwise = (SeismogramSourceLocator)SodUtil.load(otherwiseEl, "seismogram");
        }
        catch (XPathException e) {
            throw new ConfigurationException("problem with xpath", e);
        }
    }

    @Override
    public SeismogramSource getSeismogramSource(CacheEvent event, Channel channel, RequestFilter[] infilters, MeasurementStorage cookieJar) throws Exception {
        for (ChoiceSourceItem cur : this.choices) {
            if (!cur.accept(event, channel, cookieJar).isSuccess()) continue;
            return cur.getSeismogramSource(event, channel, infilters, cookieJar);
        }
        return this.otherwise.getSeismogramSource(event, channel, infilters, cookieJar);
    }
}

