/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.source.seismogram.ConstantSeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.PromiseSeismogramList;
import edu.sc.seis.sod.source.seismogram.PromiseSeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class BatchDataRequest
implements SeismogramSourceLocator,
Runnable {
    ConstantSeismogramSourceLocator wrappedLocator;
    static int NUM_LOADER_THREADS = 2;
    Thread[] loader = new Thread[NUM_LOADER_THREADS];
    int loaderSleep = 100 * NUM_LOADER_THREADS;
    List<PromiseSeismogramList> nextBatch = new ArrayList<PromiseSeismogramList>();

    public BatchDataRequest(SeismogramSourceLocator wrappedLocator) throws ConfigurationException {
        if (!(wrappedLocator instanceof ConstantSeismogramSourceLocator)) {
            throw new ConfigurationException("Batch must be for constant source locator like FdsnDataSelect");
        }
        this.wrappedLocator = (ConstantSeismogramSourceLocator)wrappedLocator;
        for (int i = 0; i < this.loader.length; ++i) {
            this.loader[i] = new Thread((Runnable)this, "Batch SeismogramSource Loader " + (i + 1));
            this.loader[i].setDaemon(true);
            this.loader[i].start();
        }
    }

    public BatchDataRequest(Element config) throws MalformedURLException, URISyntaxException, ConfigurationException {
        this((SeismogramSourceLocator)SodUtil.load(SodUtil.getFirstEmbeddedElement(config), "seismogram"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Start.isArmFailure()) {
            List<LocalSeismogramImpl> seisList;
            if (this.nextBatch.isEmpty()) {
                try {
                    BatchDataRequest batchDataRequest = this;
                    synchronized (batchDataRequest) {
                        this.wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            List<PromiseSeismogramList> reqList = this.popNextBatch();
            if (reqList.size() == 0) continue;
            ArrayList<RequestFilter> rfList = new ArrayList<RequestFilter>();
            for (PromiseSeismogramList batchProxy : reqList) {
                rfList.addAll(batchProxy.getRequest());
            }
            SeismogramSource sSource = this.wrappedLocator.getSeismogramSource();
            try {
                seisList = sSource.retrieveData(rfList);
                for (PromiseSeismogramList batchProxy : reqList) {
                    batchProxy.finishRequest(seisList);
                }
            }
            catch (SeismogramSourceException e) {
                for (PromiseSeismogramList batchProxy : reqList) {
                    batchProxy.seismogramSourceException(e);
                }
            }
            seisList = null;
            reqList = null;
            try {
                Thread.sleep(this.loaderSleep);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public SeismogramSource getSeismogramSource(CacheEvent event, Channel channel, RequestFilter[] infilters, MeasurementStorage cookieJar) throws Exception {
        return new BatchSeismogramSource();
    }

    synchronized PromiseSeismogramList addRequestToBatch(List<RequestFilter> request) {
        PromiseSeismogramList proxy = new PromiseSeismogramList(request);
        this.nextBatch.add(proxy);
        this.notifyAll();
        return proxy;
    }

    synchronized List<PromiseSeismogramList> popNextBatch() {
        List<PromiseSeismogramList> out = this.nextBatch;
        this.nextBatch = new ArrayList<PromiseSeismogramList>();
        return out;
    }

    class BatchSeismogramSource
    implements PromiseSeismogramSource {
        BatchSeismogramSource() {
        }

        @Override
        public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws SeismogramSourceException {
            PromiseSeismogramList batch = BatchDataRequest.this.addRequestToBatch(request);
            return batch.getResult();
        }

        @Override
        public PromiseSeismogramList promiseRetrieveData(List<RequestFilter> request) {
            return this.promiseRetrieveDataList(Collections.singletonList(request)).get(0);
        }

        @Override
        public List<PromiseSeismogramList> promiseRetrieveDataList(List<List<RequestFilter>> request) {
            ArrayList<PromiseSeismogramList> out = new ArrayList<PromiseSeismogramList>();
            for (List<RequestFilter> r : request) {
                out.add(BatchDataRequest.this.addRequestToBatch(r));
            }
            return out;
        }
    }
}

