/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.waveserver.MenuItem;
import edu.sc.seis.seisFile.waveserver.WaveServer;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.source.network.CSVNetworkSource;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class WinstonNetworkSource
extends CSVNetworkSource {
    private String defaultHost = "eeyore.seis.sc.edu";
    private String host;
    private int port;
    private WaveServer ws;
    private static final Logger logger = LoggerFactory.getLogger(WinstonNetworkSource.class);

    public WinstonNetworkSource(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    protected void initChannels(Element config) throws ConfigurationException {
        this.host = SodUtil.loadText(config, "host", this.defaultHost);
        this.port = SodUtil.loadInt(config, "port", 16022);
        try {
            List winstonMenu = this.getWaveServer().getMenu();
            this.channels = new ArrayList();
            for (MenuItem menuItem : winstonMenu) {
                try {
                    String netCode = menuItem.getNetwork();
                    String staCode = menuItem.getStation();
                    String chanCode = menuItem.getChannel();
                    String siteCode = menuItem.getLocation();
                    try {
                        Station curStation = this.getStationForChannel(netCode, staCode);
                        if (curStation == null) {
                            logger.warn("Can't find station for " + netCode + "." + staCode + ", skipping");
                            continue;
                        }
                        float azimuth = ChannelIdUtil.getDefaultAzimuth(chanCode);
                        float dip = ChannelIdUtil.getDefaultDip(chanCode);
                        Instant chanStart = curStation.getStartDateTime();
                        if (menuItem.getStartDate().isBefore(ClockUtil.now())) {
                            chanStart = Instant.ofEpochSecond(Math.round(menuItem.getStart()), (long)menuItem.getStart() % 1000000L);
                        }
                        TimeRange chanTime = new TimeRange(chanStart, DEFAULT_END);
                        Channel channelImpl = new Channel(curStation, siteCode, chanCode, chanTime.getBeginTime(), chanTime.getEndTime());
                        channelImpl.setAzimuth(azimuth);
                        channelImpl.setDip(dip);
                        this.channels.add(channelImpl);
                    }
                    catch (Throwable t) {
                        logger.warn("problem with channel, " + netCode + "." + staCode + "." + siteCode + "." + chanCode + " skipping", t);
                    }
                }
                catch (Throwable t) {
                    logger.warn("problem with channel, skipping", t);
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to get menu from waveserver: (" + this.host + ", " + this.port + ")", e);
        }
    }

    public WaveServer getWaveServer() {
        if (this.ws == null) {
            this.ws = new WaveServer(this.host, this.port);
        }
        return this.ws;
    }
}

