/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class RetryNetworkSource
extends WrappingNetworkSource
implements NetworkSource {
    NetworkSource wrapped;

    public RetryNetworkSource(NetworkSource sodElement) {
        super(sodElement);
        this.wrapped = sodElement;
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public Duration getRefreshInterval() {
        return this.wrapped.getRefreshInterval();
    }

    @Override
    public List<? extends Network> getNetworks() throws SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getNetworks();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry(latest, this, count++)) {
                try {
                    List<? extends Network> result = this.wrapped.getNetworks();
                    this.wrapped.getRetryStrategy().serverRecovered(this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public List<? extends Station> getStations(Network net) throws SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getStations(net);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry(latest, this, count++)) {
                try {
                    List<? extends Station> result = this.wrapped.getStations(net);
                    this.wrapped.getRetryStrategy().serverRecovered(this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public List<? extends Channel> getChannels(Station station) throws SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getChannels(station);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry(latest, this, count++)) {
                try {
                    List<? extends Channel> result = this.wrapped.getChannels(station);
                    this.wrapped.getRetryStrategy().serverRecovered(this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public Response getResponse(Channel chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        int count = 0;
        try {
            return this.wrapped.getResponse(chan);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (SodSourceException t) {
            SodSourceException latest;
            if (t.getCause() instanceof IOException || t.getCause() != null && t.getCause().getCause() instanceof IOException) {
                latest = t;
            } else {
                throw t;
            }
            while (this.wrapped.getRetryStrategy().shouldRetry(latest, this, count++)) {
                try {
                    Response result = this.wrapped.getResponse(chan);
                    this.wrapped.getRetryStrategy().serverRecovered(this);
                    return result;
                }
                catch (SodSourceException t2) {
                    if (t2.getCause() instanceof IOException || t2.getCause() != null && t2.getCause().getCause() instanceof IOException) {
                        latest = t2;
                        continue;
                    }
                    throw t2;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            throw latest;
        }
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
        this.wrapped.setConstraints(constraints);
    }
}

