/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LoadedNetworkSource
extends WrappingNetworkSource
implements NetworkSource {
    Station sta;
    List<? extends Station> allStations;
    List<? extends Channel> chans = null;
    HashSet<String> responseLoaded = new HashSet();

    public LoadedNetworkSource(NetworkSource wrapped, List<? extends Station> allStations, Station sta) {
        super(wrapped);
        this.sta = sta;
        this.allStations = allStations;
    }

    @Override
    public List<? extends Channel> getChannels(Station station) throws SodSourceException {
        if (StationIdUtil.areEqual(station, this.sta)) {
            if (this.chans == null) {
                this.chans = this.getWrapped().getChannels(this.sta);
            }
            ArrayList<? extends Channel> out = new ArrayList<Channel>();
            out.addAll(this.chans);
            return out;
        }
        return this.getWrapped().getChannels(station);
    }

    @Override
    public Response getResponse(Channel chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        this.responseLoaded.add(ChannelIdUtil.toString(chan));
        return this.getWrapped().getResponse(chan);
    }

    @Override
    public List<? extends Station> getStations(Network net) throws SodSourceException {
        if (NetworkIdUtil.areEqual(net, this.sta.getNetwork())) {
            return this.allStations;
        }
        return this.getWrapped().getStations(net);
    }

    public boolean isResponseLoaded(ChannelId chan) {
        return this.responseLoaded.contains(ChannelIdUtil.toString(chan));
    }
}

