/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationFromDB
extends WrappingNetworkSource
implements NetworkSource {
    private static HashMap<String, String> inProgress = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationFromDB.class);

    public InstrumentationFromDB(NetworkSource wrapped) {
        super(wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getResponse(Channel chan) throws ChannelNotFound, SodSourceException {
        Response inst;
        HashMap<String, String> hashMap;
        String key = ChannelIdUtil.toString(chan);
        try {
            hashMap = inProgress;
            synchronized (hashMap) {
                while (inProgress.containsKey(key)) {
                    try {
                        inProgress.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                inProgress.put(key, "working");
                inProgress.notifyAll();
            }
            inst = NetworkDB.getSingleton().getResponse(chan);
            if (!Response.isValid((Response)inst)) {
                logger.warn("bad instrumentation in db, regetting. " + ChannelIdUtil.toStringNoDates(chan));
                NetworkDB.getSingleton().putResponse(chan, null);
                inst = null;
            }
            if (inst == null) {
                try {
                    inst = this.getWrapped().getResponse(chan);
                    NetworkDB.getSingleton().putResponse(chan, inst);
                }
                catch (ChannelNotFound e) {
                    logger.warn("exception", (Throwable)e);
                    NetworkDB.getSingleton().putResponse(chan, null);
                }
                catch (InvalidResponse e) {
                    logger.warn("exception", (Throwable)e);
                    NetworkDB.getSingleton().putResponse(chan, null);
                }
                catch (SodSourceException e) {
                    logger.warn("exception", (Throwable)e);
                    NetworkDB.getSingleton().putResponse(chan, null);
                }
            }
        }
        finally {
            hashMap = inProgress;
            synchronized (hashMap) {
                inProgress.remove(key);
                inProgress.notifyAll();
            }
        }
        return inst;
    }
}

