/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import edu.sc.seis.sod.BuildVersion;
import edu.sc.seis.sod.RunProperties;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.model.common.BoxAreaImpl;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.AbstractNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.subsetter.station.StationPointDistance;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FdsnStation
extends AbstractNetworkSource {
    boolean includeAvailability = true;
    boolean validateXML = false;
    FDSNStationQueryParams queryParams = new FDSNStationQueryParams();
    private static final Logger logger = LoggerFactory.getLogger(FdsnStation.class);

    public FdsnStation() {
        super("defaultFDSNNetwork", -1);
    }

    public FdsnStation(String name, int retries, FDSNStationQueryParams queryParams) {
        super(name, retries);
        this.queryParams = queryParams;
    }

    public FdsnStation(Element config) throws Exception {
        super(config);
        this.queryParams.clearIncludeRestricted();
        this.queryParams.clearIncludeAvailability();
        this.includeAvailability = SodUtil.isTrue(config, "includeAvailability", true);
        this.validateXML = SodUtil.isTrue(config, "validate", false);
        if (config != null) {
            String scheme;
            int port = SodUtil.loadInt(config, "port", -1);
            if (port > 0) {
                this.queryParams.setPort(port);
            }
            if ((scheme = SodUtil.loadText(config, "scheme", null)) != null && scheme.length() != 0) {
                this.queryParams.setScheme(scheme);
                if (port == -1) {
                    if (scheme.equalsIgnoreCase("http")) {
                        this.queryParams.setPort(80);
                    }
                    if (scheme.equalsIgnoreCase("https")) {
                        this.queryParams.setPort(443);
                    }
                }
            }
            NodeList childNodes = config.getChildNodes();
            for (int counter = 0; counter < childNodes.getLength(); ++counter) {
                String fdsnwsPath;
                Node node = childNodes.item(counter);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if (element.getTagName().equals("stationBoxArea")) {
                    BoxAreaImpl a = SodUtil.loadBoxArea(element);
                    this.queryParams.area(a.min_latitude, a.max_latitude, a.min_longitude, a.max_longitude);
                    continue;
                }
                if (element.getTagName().equals("stationPointDistance")) {
                    StationPointDistance pd = (StationPointDistance)SodUtil.load(element, new String[]{"station"});
                    this.queryParams.donut(pd.asDonut());
                    continue;
                }
                if (element.getTagName().equals("networkCode")) {
                    this.queryParams.appendToNetwork(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("stationCode")) {
                    this.queryParams.appendToStation(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("siteCode")) {
                    this.queryParams.appendToLocation(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("channelCode")) {
                    this.queryParams.appendToChannel(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("includeRestricted")) {
                    this.queryParams.setIncludeRestricted(true);
                    continue;
                }
                if (element.getTagName().equals("matchTimeseries")) {
                    logger.debug("Setting matchtimeseries");
                    this.queryParams.setMatchTimeseries(true);
                    continue;
                }
                if (element.getTagName().equals("host")) {
                    String host = SodUtil.getNestedText(element);
                    this.queryParams.setHost(host);
                    this.name = host;
                    continue;
                }
                if (!element.getTagName().equals("fdsnwsPath") || (fdsnwsPath = SodUtil.getNestedText(element)) == null || fdsnwsPath.length() == 0) continue;
                this.queryParams.setFdsnwsPath(fdsnwsPath);
                logger.debug("Set fdsnwsPath: " + fdsnwsPath);
            }
        }
    }

    public void includeRestricted(boolean val) {
        this.queryParams.setIncludeRestricted(val);
    }

    @Override
    public List<? extends Network> getNetworks() throws SodSourceException {
        ArrayList<Network> out = new ArrayList<Network>();
        FDSNStationXML staxml = null;
        try {
            FDSNStationQueryParams staQP = this.setupQueryParams();
            staQP.setLevel(FDSNStationQueryParams.LEVEL_NETWORK);
            staQP.clearChannel();
            staQP.clearStartAfter().clearStartBefore().clearStartTime();
            staQP.clearEndAfter().clearEndBefore().clearEndTime();
            logger.debug("getNetworks " + String.valueOf(staQP.formURI()));
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            while (netIt.hasNext()) {
                Network n = netIt.next();
                out.add(n);
            }
            ArrayList<Network> arrayList = out;
            return arrayList;
        }
        catch (URISyntaxException e) {
            throw new SodSourceException("Problem forming URI", e);
        }
        catch (SeisFileException e) {
            throw new SodSourceException(e);
        }
        catch (XMLValidationException e) {
            logger.warn("InvalidXML: getting networks" + e.getMessage().replace('\n', ' '));
            logger.debug("InvalidXML: getting networks" + e.getMessage().replace('\n', ' '), (Throwable)e);
            ArrayList<Network> arrayList = out;
            return arrayList;
        }
        catch (XMLStreamException e) {
            throw new SodSourceException(e);
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    @Override
    public List<? extends Station> getStations(Network net) throws SodSourceException {
        ArrayList<Station> out = new ArrayList<Station>();
        FDSNStationXML staxml = null;
        try {
            Object paramNets;
            FDSNStationQueryParams staQP = this.setupQueryParams();
            String netString = staQP.getParam("network");
            if (netString != null) {
                paramNets = netString.split(",");
                staQP.clearNetwork();
                for (int i = 0; i < ((String[])paramNets).length; ++i) {
                    if (paramNets[i].length() <= 2) continue;
                    staQP.appendToNetwork(paramNets[i]);
                }
            }
            staQP.setLevel(FDSNStationQueryParams.LEVEL_STATION);
            staQP.appendToNetwork(net.getNetworkCode());
            if (!FdsnStation.checkTimeParamsOk(net.getStartDateTime(), net.getEndDateTime(), this.constraints)) {
                logger.info("time window for " + String.valueOf(net) + " " + String.valueOf(net.getStartDateTime()) + " " + String.valueOf(net.getEndDateTime()) + " does not overlap sod constraints: " + String.valueOf(this.constraints.getConstrainingBeginTime()) + " " + String.valueOf(this.constraints.getConstrainingEndTime()) + ", skipping.");
                paramNets = out;
                return paramNets;
            }
            FdsnStation.setTimeParams(staQP, net.getStartDateTime(), net.getEndDateTime(), this.constraints);
            logger.debug("getStations " + String.valueOf(staQP.formURI()));
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            while (netIt.hasNext()) {
                Network n = netIt.next();
                StationIterator staIt = n.getStations();
                while (staIt.hasNext()) {
                    Station s = staIt.next();
                    out.add(s);
                }
            }
            ArrayList<Station> arrayList = out;
            return arrayList;
        }
        catch (URISyntaxException e) {
            throw new SodSourceException("Problem forming URI", e);
        }
        catch (SeisFileException e) {
            throw new SodSourceException(e);
        }
        catch (XMLValidationException e) {
            logger.warn("InvalidXML: " + net.toString() + " " + e.getMessage().replace('\n', ' '));
            logger.debug("InvalidXML: " + net.toString() + " " + e.getMessage().replace('\n', ' '), (Throwable)e);
            ArrayList<Station> arrayList = out;
            return arrayList;
        }
        catch (XMLStreamException e) {
            throw new SodSourceException(e);
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    @Override
    public List<? extends Channel> getChannels(Station station) throws SodSourceException {
        ArrayList<Channel> out = new ArrayList<Channel>();
        FDSNStationXML staxml = null;
        try {
            FDSNStationQueryParams staQP = this.setupQueryParams();
            staQP.setLevel(FDSNStationQueryParams.LEVEL_CHANNEL);
            staQP.setIncludeAvailability(this.includeAvailability);
            staQP.clearNetwork().appendToNetwork(station.getNetworkCode()).clearStation().appendToStation(station.getStationCode());
            if (!FdsnStation.checkTimeParamsOk(station.getStartDateTime(), station.getEndDateTime(), this.constraints)) {
                logger.info("time window for " + String.valueOf(station) + " " + String.valueOf(station.getStartDateTime()) + " " + String.valueOf(station.getEndDateTime()) + " does not overlap sod constraints: " + String.valueOf(this.constraints.getConstrainingBeginTime()) + " " + String.valueOf(this.constraints.getConstrainingEndTime()) + ", skipping.");
                ArrayList<Channel> arrayList = out;
                return arrayList;
            }
            FdsnStation.setTimeParams(staQP, station.getStartDateTime(), station.getEndDateTime(), this.constraints);
            logger.info("getChannels " + String.valueOf(staQP.formURI()));
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            while (netIt.hasNext()) {
                Network n = netIt.next();
                StationIterator staIt = n.getStations();
                while (staIt.hasNext()) {
                    Station s = staIt.next();
                    for (Channel c : s.getChannelList()) {
                        out.add(c);
                    }
                }
            }
            ArrayList<Channel> arrayList = out;
            return arrayList;
        }
        catch (URISyntaxException e) {
            throw new SodSourceException("Problem forming URI", e);
        }
        catch (SeisFileException e) {
            throw new SodSourceException(e);
        }
        catch (XMLValidationException e) {
            logger.warn("InvalidXML: " + StationIdUtil.toString(station) + " " + e.getMessage().replace('\n', ' '));
            logger.debug("InvalidXML: " + StationIdUtil.toString(station) + " " + e.getMessage().replace('\n', ' '), (Throwable)e);
            ArrayList<Channel> arrayList = out;
            return arrayList;
        }
        catch (XMLStreamException e) {
            throw new SodSourceException(e);
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response getResponse(Channel chan) throws SodSourceException, ChannelNotFound, InvalidResponse {
        FDSNStationXML staxml = null;
        try {
            if (chan == null) {
                throw new IllegalArgumentException("Channel is null");
            }
            FDSNStationQueryParams staQP = this.setupQueryParams();
            staQP.setLevel(FDSNStationQueryParams.LEVEL_RESPONSE);
            staQP.clearNetwork().appendToNetwork(chan.getNetworkCode()).clearStation().appendToStation(chan.getStationCode()).clearLocation().appendToLocation(chan.getLocCode()).clearChannel().appendToChannel(chan.getChannelCode());
            FdsnStation.setTimeParamsToGetSingleChan(staQP, chan.getStartDateTime(), chan.getEndDateTime());
            logger.debug("getResponse " + String.valueOf(staQP.formURI()));
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            block9: while (true) {
                if (!netIt.hasNext()) throw new ChannelNotFound(chan);
                Network n = netIt.next();
                StationIterator staIt = n.getStations();
                while (true) {
                    if (!staIt.hasNext()) continue block9;
                    Station s = staIt.next();
                    Iterator iterator = s.getChannelList().iterator();
                    if (iterator.hasNext()) {
                        Channel c = (Channel)iterator.next();
                        if (staxml != null) {
                            staxml.closeReader();
                            staxml = null;
                        }
                        Response response = c.getResponse();
                        return response;
                    }
                    continue;
                    break;
                }
                break;
            }
        }
        catch (URISyntaxException e) {
            throw new SodSourceException("Problem forming URI", e);
        }
        catch (SeisFileException e) {
            throw new SodSourceException(e);
        }
        catch (XMLValidationException e) {
            logger.warn("InvalidXML: " + ChannelIdUtil.toString(chan) + " " + e.getMessage().replace('\n', ' '));
            logger.debug("InvalidXML: " + ChannelIdUtil.toString(chan) + " " + e.getMessage().replace('\n', ' '), (Throwable)e);
            throw new InvalidResponse((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new SodSourceException(e);
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    FDSNStationQueryParams setupQueryParams() {
        FDSNStationQueryParams cloneQP = this.queryParams.clone();
        if (this.constraints != null) {
            for (String netCode : this.constraints.getConstrainingNetworkCodes()) {
                cloneQP.appendToNetwork(netCode);
            }
            for (String staCode : this.constraints.getConstrainingStationCodes()) {
                cloneQP.appendToStation(staCode);
            }
            for (String siteCode : this.constraints.getConstrainingLocationCodes()) {
                cloneQP.appendToLocation(siteCode);
            }
            for (String chanCode : this.constraints.getConstrainingChannelCodes()) {
                cloneQP.appendToChannel(chanCode);
            }
            if (this.constraints.getConstrainingBeginTime() != null) {
                cloneQP.setEndAfter(this.constraints.getConstrainingBeginTime());
            }
            if (this.constraints.getConstrainingEndTime() != null) {
                cloneQP.setStartBefore(this.constraints.getConstrainingEndTime());
            }
        }
        return cloneQP;
    }

    FDSNStationQuerier setupQuerier(FDSNStationQueryParams queryParams) {
        FDSNStationQuerier querier = new FDSNStationQuerier(queryParams);
        RunProperties runProps = Start.getRunProps();
        if (runProps.getProxyHost() != null) {
            querier.setProxyHost(runProps.getProxyHost());
            querier.setProxyPort(runProps.getProxyPort());
            querier.setProxyProtocol(runProps.getProxyScheme());
        }
        if (this.validateXML) {
            querier.setValidate(true);
        }
        querier.setUserAgent("SOD/" + BuildVersion.getVersion());
        return querier;
    }

    FDSNStationXML internalGetStationXML(FDSNStationQueryParams staQP) {
        int count = 0;
        SeisFileException latest = null;
        FDSNStationXML out = null;
        while (count == 0 || this.getRetryStrategy().shouldRetry(latest, this, count)) {
            try {
                FDSNStationQuerier querier = this.setupQuerier(staQP);
                out = querier.getFDSNStationXML();
                if (count > 0) {
                    this.getRetryStrategy().serverRecovered(this);
                }
                return out;
            }
            catch (SeisFileException e) {
                ++count;
                if (out != null) {
                    out.closeReader();
                    out = null;
                }
                latest = e;
                Throwable rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)e);
                if (rootCause instanceof IOException) continue;
                if (e instanceof FDSNWSException && ((FDSNWSException)e).getHttpResponseCode() != 200) {
                    latest = e;
                    if (((FDSNWSException)e).getHttpResponseCode() != 400) continue;
                    Start.simpleArmFailure(Start.getNetworkArm(), "The remote web service just indicated that the query was badly formed. This may be because it does not support all of the parameters that SOD uses or it could be a bug in SOD. Check your recipe and if you cannot figure it out contact the developers at sod@seis.sc.edu.  " + ((FDSNWSException)e).getMessage() + " on " + String.valueOf(((FDSNWSException)e).getTargetURI()));
                    continue;
                }
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw new RuntimeException(latest);
    }

    public FDSNStationQueryParams getDefaultQueryParams() {
        return this.queryParams;
    }

    static void setTimeParamsToGetSingleChan(FDSNStationQueryParams staQP, Instant startTime, Instant endTime) {
        staQP.setStartBefore(startTime.plus(TimeUtils.ONE_SECOND));
        Instant end = endTime;
        if (end != null && end.isBefore(ClockUtil.now())) {
            staQP.setEndAfter(end.minus(TimeUtils.ONE_SECOND));
        }
    }

    static boolean checkTimeParamsOk(Instant startTime, Instant endTime, NetworkQueryConstraints constraints) {
        if (startTime.equals(endTime)) {
            // empty if block
        }
        if (endTime != null && startTime.isAfter(endTime)) {
            return false;
        }
        if (constraints.getConstrainingEndTime() != null && constraints.getConstrainingEndTime().isBefore(startTime)) {
            return false;
        }
        return constraints.getConstrainingBeginTime() == null || endTime == null || !constraints.getConstrainingBeginTime().isAfter(endTime);
    }

    static void setTimeParams(FDSNStationQueryParams staQP, Instant startTime, Instant endTime, NetworkQueryConstraints constraints) {
        Instant earliest = startTime;
        Instant latest = endTime;
        if (constraints != null) {
            if (earliest == null || constraints.getConstrainingBeginTime() != null && constraints.getConstrainingBeginTime().isAfter(earliest)) {
                earliest = constraints.getConstrainingBeginTime();
            }
            if (latest == null || constraints.getConstrainingEndTime() != null && constraints.getConstrainingEndTime().isBefore(latest)) {
                latest = constraints.getConstrainingEndTime();
            }
        }
        if (earliest != null) {
            staQP.setEndAfter(earliest);
        }
        if (latest != null && latest.isBefore(ClockUtil.now())) {
            staQP.setStartBefore(latest);
        }
    }
}

