/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.AbstractNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CombineNetworkSource
extends AbstractNetworkSource
implements NetworkSource {
    List<NetworkSource> wrapped;
    HashMap<String, NetworkSource> codeToSource = new HashMap();

    public CombineNetworkSource(Element config) throws ConfigurationException {
        super(config);
        this.wrapped = new ArrayList<NetworkSource>();
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            this.wrapped.add((NetworkSource)SodUtil.load(el, new String[]{"network"}));
        }
    }

    @Override
    public String getName() {
        String out = this.getClass().getSimpleName() + "[";
        for (NetworkSource source : this.wrapped) {
            out = out + source.getName() + ", ";
        }
        return out.substring(0, out.length() - 2) + "]";
    }

    @Override
    public Duration getRefreshInterval() {
        Duration out = Duration.ofMillis(-1L);
        for (NetworkSource source : this.wrapped) {
            if (out.toNanos() >= 0L && out.toNanos() <= source.getRefreshInterval().toNanos()) continue;
            out = source.getRefreshInterval();
        }
        return out;
    }

    public NetworkSource getNetworkSource(Network attr) {
        NetworkSource source;
        String code = attr.toString();
        try {
            source = this.getSourceForCode(code);
        }
        catch (SodSourceException e) {
            throw new RuntimeException("Network not found: " + attr.toString());
        }
        return source;
    }

    @Override
    public synchronized List<? extends Network> getNetworks() throws SodSourceException {
        ArrayList<Network> out = new ArrayList<Network>();
        for (NetworkSource source : this.wrapped) {
            List<? extends Network> subOut = source.getNetworks();
            if (subOut == null) continue;
            for (Network network : subOut) {
                String code = network.toString();
                if (this.codeToSource.containsKey(code)) continue;
                this.codeToSource.put(code, source);
                out.add(network);
            }
        }
        return out;
    }

    @Override
    public List<? extends Station> getStations(Network net) throws SodSourceException {
        NetworkSource source = this.getSourceForCode(net.toString());
        if (source != null) {
            return source.getStations(net);
        }
        return new ArrayList();
    }

    @Override
    public List<? extends Channel> getChannels(Station station) throws SodSourceException {
        NetworkSource source = this.getSourceForCode(station.getNetwork().toString());
        if (source != null) {
            return source.getChannels(station);
        }
        return new ArrayList();
    }

    @Override
    public Response getResponse(Channel chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        Response out;
        NetworkSource source = this.getSourceForCode(chan.getNetwork().toString());
        if (source != null && (out = source.getResponse(chan)) != null) {
            return out;
        }
        throw new ChannelNotFound(chan);
    }

    synchronized NetworkSource getSourceForCode(String code) throws SodSourceException {
        if (this.codeToSource.containsKey(code)) {
            return this.codeToSource.get(code);
        }
        for (NetworkSource source : this.wrapped) {
            List<? extends Network> sublist = source.getNetworks();
            for (Network network : sublist) {
                if (!code.equals(network.toString())) continue;
                this.codeToSource.put(code, source);
                return source;
            }
        }
        return null;
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
        for (NetworkSource source : this.wrapped) {
            source.setConstraints(constraints);
        }
    }
}

