/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import com.csvreader.CsvReader;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Comment;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Operator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.Site;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.source.AbstractCSVSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.subsetter.AreaSubsetter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class CSVNetworkSource
extends AbstractCSVSource
implements NetworkSource {
    protected List<Network> networks;
    protected List<Station> stations;
    protected List<Channel> channels;
    public static final String NET_CODE = "net.code";
    public static final String STATION_CODE = "station.code";
    public static final String LOC_CODE = "loc.code";
    public static final String CODE = "code";
    public static final String NET_START = "net.start";
    public static final String NET_END = "net.end";
    public static final String SAMPLE_PERIOD = "sampling.period";
    public static final String SAMPLE_FREQUENCY = "sampling.frequency";
    public static final String START = "start";
    public static final String END = "end";
    public static final String OPERATOR = "operator";
    public static final String COMMENT = "comment";
    public static final String DESCRIPTION = "description";
    public static final String AZIMUTH = "azimuth";
    public static final String DIP = "dip";
    private static final String[] networkFields = new String[]{"net.code", "station.code", "loc.code", "code", "longitude", "latitude", "elevation", "elevationUnits", "depth", "depthUnits", "sampling.period", "sampling.frequency", "net.start", "net.end", "start", "end", "name", "flinnEngdahlSeismicRegion", "flinnEngdahlGeographicRegion", "flinnEngdahlRegion", "flinnEngdahlRegionType", "azimuth", "dip", "operator", "comment", "description"};

    public CSVNetworkSource(Element config) throws ConfigurationException {
        super(config, "CSVNetworkSource");
        this.initStations(config);
        this.initChannels(config);
    }

    protected void initStations(Element config) throws ConfigurationException {
        if (DOMHelper.hasElement(config, "stationFile")) {
            String filename;
            this.csvFilename = filename = DOMHelper.extractText(config, "stationFile");
            try {
                this.stations = this.getStationsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(this.csvFilename));
            }
            catch (FileNotFoundException e) {
                throw new UserConfigurationException(e.getMessage() + " as a station CSV file.");
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read " + this.csvFilename, e);
            }
        } else if (DOMHelper.hasElement(config, "stations")) {
            try {
                this.stations = this.getStationsFromReader(new StringReader(DOMHelper.extractText(config, "stations").trim()));
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read stations from:" + DOMHelper.extractText(config, "stations"), e);
            }
        } else {
            throw new ConfigurationException("Can't find stationFile or stations in configuration.");
        }
        this.networks = this.getNetworksFromStations(this.stations);
    }

    protected void initChannels(Element config) throws ConfigurationException {
        if (DOMHelper.hasElement(config, "channelFile")) {
            String filename = DOMHelper.extractText(config, "channelFile");
            try {
                this.channels = this.getChannelsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(filename), this.stations);
            }
            catch (FileNotFoundException e) {
                throw new UserConfigurationException(e.getMessage() + " as a channel CSV file.", e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read " + filename, e);
            }
        } else if (DOMHelper.hasElement(config, "channels")) {
            try {
                this.channels = this.getChannelsFromReader(new StringReader(DOMHelper.extractText(config, "channels").trim()), this.stations);
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read channels from:" + DOMHelper.extractText(config, "channels"), e);
            }
        } else {
            throw new ConfigurationException("Can't find channelFile or channels in configuration.");
        }
    }

    public CSVNetworkSource(String stationFile, String channelFile) throws ConfigurationException, FileNotFoundException, IOException {
        super("CSVNetworkSource");
        this.stations = this.getStationsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(stationFile));
        this.channels = this.getChannelsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(channelFile), this.stations);
    }

    public String getDescription() {
        return "CSVNetworkSource: " + this.csvFilename;
    }

    public List<Network> getNetworksFromStations(List<Station> staList) {
        HashMap<String, Network> nets = new HashMap<String, Network>();
        for (Station sta : staList) {
            nets.put(StationIdUtil.toStringNoDates(sta), sta.getNetwork());
        }
        ArrayList<Network> out = new ArrayList<Network>();
        for (Network net : nets.values()) {
            out.add(net);
        }
        return out;
    }

    public List<Station> getStationsFromReader(Reader reader) throws IOException, FileNotFoundException, ConfigurationException {
        ArrayList<Station> stations = new ArrayList<Station>();
        CsvReader csvReader = new CsvReader(reader);
        List<String> headers = this.validateHeaders(csvReader);
        while (csvReader.readRecord()) {
            String netCode = csvReader.get(NET_CODE);
            String staCode = csvReader.get(CODE);
            float latitude = CSVNetworkSource.loadFloat(headers, csvReader, "latitude", 0.0f);
            float longitude = CSVNetworkSource.loadFloat(headers, csvReader, "longitude", 0.0f);
            double elevation = CSVNetworkSource.loadDouble(headers, csvReader, "elevation", 0.0);
            double depth = CSVNetworkSource.loadDouble(headers, csvReader, "depth", 0.0);
            UnitImpl elevationUnit = CSVNetworkSource.loadUnit(headers, csvReader, "elevationUnits", UnitImpl.METER);
            UnitImpl depthUnit = CSVNetworkSource.loadUnit(headers, csvReader, "depthUnits", UnitImpl.METER);
            Location location = new Location(latitude, longitude, new QuantityImpl(elevation, elevationUnit), new QuantityImpl(depth, depthUnit));
            Instant staBegin = CSVNetworkSource.loadTime(headers, csvReader, START, DEFAULT_TIME);
            Network network = new Network(netCode);
            network.setStartDateTime(CSVNetworkSource.loadTime(headers, csvReader, NET_START, DEFAULT_TIME));
            Station station = new Station(network, staCode);
            station.setLatitude(latitude);
            station.setLongitude(longitude);
            station.setElevation((float)elevation);
            station.setStartDateTime(staBegin);
            station.addOperator(new Operator(CSVNetworkSource.loadString(headers, csvReader, OPERATOR, "")));
            station.setSite(new Site("", CSVNetworkSource.loadString(headers, csvReader, DESCRIPTION, ""), "", "", "", ""));
            station.addComment(new Comment(CSVNetworkSource.loadString(headers, csvReader, COMMENT, "")));
            stations.add(station);
        }
        return stations;
    }

    protected Station getStationForChannel(String netCode, String staCode) {
        for (Station stationImpl : this.stations) {
            if (!netCode.equals(stationImpl.getNetworkCode()) || !staCode.equals(stationImpl.getCode())) continue;
            return stationImpl;
        }
        return null;
    }

    public List<Channel> getChannelsFromReader(Reader reader, List<Station> stations) throws IOException, FileNotFoundException, ConfigurationException {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        CsvReader csvReader = new CsvReader(reader);
        List<String> headers = this.validateHeaders(csvReader);
        while (csvReader.readRecord()) {
            Location location;
            String netCode = csvReader.get(NET_CODE);
            String staCode = csvReader.get(STATION_CODE);
            String locCode = Channel.fixLocCode((String)csvReader.get(LOC_CODE));
            String chanCode = csvReader.get(CODE);
            Station curStation = this.getStationForChannel(netCode, staCode);
            if (curStation == null) {
                throw new UserConfigurationException("Station " + netCode + "." + staCode + " is not a known station. Add it to the stations section.");
            }
            if (headers.contains("latitude") || headers.contains("longitude") || headers.contains("elevation") || headers.contains("depth")) {
                float latitude = CSVNetworkSource.loadFloat(headers, csvReader, "latitude", 0.0f);
                float longitude = CSVNetworkSource.loadFloat(headers, csvReader, "longitude", 0.0f);
                double elevation = CSVNetworkSource.loadDouble(headers, csvReader, "elevation", 0.0);
                double depth = CSVNetworkSource.loadDouble(headers, csvReader, "depth", 0.0);
                UnitImpl elevationUnit = CSVNetworkSource.loadUnit(headers, csvReader, "elevationUnits", UnitImpl.METER);
                UnitImpl depthUnit = CSVNetworkSource.loadUnit(headers, csvReader, "depthUnits", UnitImpl.METER);
                location = new Location(latitude, longitude, new QuantityImpl(elevation, elevationUnit), new QuantityImpl(depth, depthUnit));
            } else {
                location = Location.of(curStation);
            }
            Instant chanBegin = CSVNetworkSource.loadTime(headers, csvReader, START, DEFAULT_TIME);
            float azimuth = CSVNetworkSource.loadFloat(headers, csvReader, AZIMUTH, ChannelIdUtil.getDefaultAzimuth(chanCode));
            float dip = CSVNetworkSource.loadFloat(headers, csvReader, DIP, ChannelIdUtil.getDefaultDip(chanCode));
            SamplingImpl sampling = headers.contains(SAMPLE_PERIOD) ? SamplingImpl.ofSamplesSeconds(1, CSVNetworkSource.loadFloat(headers, csvReader, SAMPLE_PERIOD, 1.0f)) : (headers.contains(SAMPLE_FREQUENCY) ? SamplingImpl.ofSamplesSeconds(1, 1.0f / CSVNetworkSource.loadFloat(headers, csvReader, SAMPLE_FREQUENCY, 1.0f)) : SamplingImpl.ofSamplesSeconds(1, 1.0));
            TimeRange chanTime = new TimeRange(chanBegin, CSVNetworkSource.loadTime(headers, csvReader, END, DEFAULT_END));
            Channel channel = new Channel(curStation, locCode, chanCode, chanTime.getBeginTime(), chanTime.getEndTime());
            channel.setAzimuth(azimuth);
            channel.setDip(dip);
            channel.setSampleRate((float)sampling.getFrequency().getValue(UnitImpl.HERTZ));
            channels.add(channel);
        }
        return channels;
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
    }

    public String toString() {
        return "CSVNetworkSource using " + this.csvFilename;
    }

    @Override
    public List<? extends Channel> getChannels(Station station) {
        ArrayList<Channel> out = new ArrayList<Channel>();
        for (Channel chan : this.channels) {
            if (!StationIdUtil.areEqual(station, chan.getStation())) continue;
            out.add(chan);
        }
        return out;
    }

    @Override
    public Response getResponse(Channel chan) throws ChannelNotFound, InvalidResponse {
        throw new ChannelNotFound("Response not in CSVNetworkSource", chan);
    }

    @Override
    public List<? extends Network> getNetworks() {
        return Collections.unmodifiableList(this.networks);
    }

    @Override
    public List<? extends Station> getStations(Network net) {
        ArrayList<Station> staList = new ArrayList<Station>();
        for (Station sta : this.stations) {
            if (!NetworkIdUtil.areEqual(net, sta.getNetwork())) continue;
            staList.add(sta);
        }
        return staList;
    }

    @Override
    public String[] getFields() {
        return networkFields;
    }

    @Override
    public Duration getRefreshInterval() {
        return TimeUtils.ZERO_DURATION;
    }

    @Override
    public String getName() {
        if (this.csvFilename != null && this.csvFilename.length() != 0) {
            return this.csvFilename;
        }
        return "inline";
    }
}

