/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import java.time.Duration;
import org.w3c.dom.Element;

public abstract class AbstractNetworkSource
extends AbstractSource
implements NetworkSource {
    protected NetworkQueryConstraints constraints;
    protected Duration refreshInterval;
    Duration FORTNIGHT;
    public static final String REFRESH_ELEMENT = "refreshInterval";

    public AbstractNetworkSource(String name, int retries) {
        super(name, retries);
        this.refreshInterval = this.FORTNIGHT = Duration.ofDays(14L);
    }

    public AbstractNetworkSource(NetworkSource wrapped) {
        this(wrapped.getName(), wrapped.getRetries());
    }

    public AbstractNetworkSource(Element config) throws ConfigurationException {
        super(config, "default", -1);
        this.FORTNIGHT = Duration.ofDays(14L);
        Element subElement = SodUtil.getElement(config, REFRESH_ELEMENT);
        this.refreshInterval = subElement != null ? SodUtil.loadTimeInterval(subElement) : this.FORTNIGHT;
    }

    @Override
    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
        this.constraints = constraints;
    }
}

