/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.event.EventSource;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class SimpleEventSource
extends AbstractSource
implements EventSource {
    public boolean hasNextBeenCalled = false;
    private static final Logger logger = LoggerFactory.getLogger(SimpleEventSource.class);

    public SimpleEventSource(Element config, String defaultName, int defaultRetries) {
        super(config, defaultName, defaultRetries);
    }

    public SimpleEventSource(Element config, String defaultName) {
        super(config, defaultName);
    }

    public SimpleEventSource(String name, int retries) {
        super(name, retries);
    }

    public SimpleEventSource(String name) {
        super(name);
    }

    public abstract CacheEvent[] getEvents();

    @Override
    public boolean hasNext() {
        return !this.hasNextBeenCalled;
    }

    @Override
    public CacheEvent[] next() {
        this.hasNextBeenCalled = true;
        CacheEvent[] out = this.getEvents();
        logger.debug("returning " + out.length + " events");
        return out;
    }

    @Override
    public Duration getWaitBeforeNext() {
        if (this.hasNextBeenCalled) {
            throw new RuntimeException("SHouldn't happen");
        }
        return Duration.ofSeconds(0L);
    }

    @Override
    public TimeRange getEventTimeRange() {
        Instant earliest;
        CacheEvent[] events = this.getEvents();
        Instant latest = earliest = this.extractBeginTime(events[0]);
        for (int i = 0; i < events.length; ++i) {
            Instant eventTime = this.extractBeginTime(events[i]);
            if (eventTime.isBefore(earliest)) {
                earliest = eventTime;
                continue;
            }
            if (!eventTime.isAfter(latest)) continue;
            latest = eventTime;
        }
        return new TimeRange(earliest, latest);
    }

    public Instant extractBeginTime(CacheEvent ev) {
        return ev.getOrigin().getOriginTime();
    }
}

