/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.mock.event.MockEventAttr;
import edu.sc.seis.sod.mock.event.MockOrigin;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;
import org.w3c.dom.Element;

public class PeriodicFakeEventSource
extends AbstractSource
implements EventSource {
    Instant startTime;
    Duration interval;
    Instant nextEventTime;
    Instant prevEventTime = null;
    int numEvents = -1;
    int eventCounter = 0;
    static Magnitude[] mags = new Magnitude[]{new Magnitude("FAKE", -10.0f, "nobody")};

    protected PeriodicFakeEventSource(Instant startTime, Duration interval, int numEvents) {
        super("PeriodicFakeEventSource");
        this.startTime = startTime;
        this.interval = interval;
        this.numEvents = numEvents;
        this.nextEventTime = startTime;
    }

    public PeriodicFakeEventSource(Element config) throws ConfigurationException {
        super(config, "PeriodicFakeEventSource ");
        this.startTime = SodUtil.loadTime(SodUtil.getElement(config, "startTime")).load();
        this.interval = SodUtil.loadTimeInterval(SodUtil.getElement(config, "interval"));
        this.numEvents = SodUtil.loadInt(config, "numEvents", -1);
        this.nextEventTime = this.startTime;
    }

    public String getDescription() {
        return "Periodic Fake Events " + this.numEvents + " events from " + String.valueOf(this.startTime) + " in steps of " + String.valueOf(this.interval);
    }

    @Override
    public TimeRange getEventTimeRange() {
        if (this.numEvents != -1) {
            return new TimeRange(this.startTime, this.interval.multipliedBy(this.numEvents - 1));
        }
        return new TimeRange(this.startTime, ClockUtil.wayFuture());
    }

    @Override
    public Duration getWaitBeforeNext() {
        if (this.nextEventTime.isBefore(ClockUtil.now())) {
            return Duration.ofSeconds(0L);
        }
        return Duration.between(ClockUtil.now(), this.nextEventTime);
    }

    @Override
    public boolean hasNext() {
        return this.numEvents == -1 || this.eventCounter < this.numEvents;
    }

    @Override
    public CacheEvent[] next() {
        if (this.nextEventTime.isBefore(ClockUtil.now())) {
            ++this.eventCounter;
            this.prevEventTime = this.nextEventTime;
            this.nextEventTime = this.startTime.plus(this.interval.multipliedBy(this.eventCounter));
            return new CacheEvent[]{new CacheEvent(MockEventAttr.create(-1), MockOrigin.create(this.prevEventTime, mags))};
        }
        return new CacheEvent[0];
    }
}

