/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.mock.event.MockEventAttr;
import edu.sc.seis.sod.mock.event.MockOrigin;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.source.event.PeriodicFakeEventSource;
import edu.sc.seis.sod.util.time.ClockUtil;
import org.w3c.dom.Element;

public class NowFakeEventSource
extends PeriodicFakeEventSource {
    public NowFakeEventSource(Element config) throws ConfigurationException {
        super(ClockUtil.now(), SodUtil.loadTimeInterval(SodUtil.getElement(config, "interval")), SodUtil.loadInt(config, "numEvents", -1));
    }

    @Override
    public String getDescription() {
        return "Events starting now, with " + this.numEvents + " new events at the current request time but no more frequent than " + String.valueOf(this.interval);
    }

    @Override
    public TimeRange getEventTimeRange() {
        return new TimeRange(this.startTime, ClockUtil.wayFuture());
    }

    @Override
    public CacheEvent[] next() {
        if (this.nextEventTime.isBefore(ClockUtil.now())) {
            ++this.eventCounter;
            this.prevEventTime = ClockUtil.now();
            this.nextEventTime = this.prevEventTime.plus(this.interval);
            return new CacheEvent[]{new CacheEvent(MockEventAttr.create(-1), MockOrigin.create(this.prevEventTime, mags))};
        }
        return new CacheEvent[0];
    }
}

