/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.sc.seis.seisFile.DonutArea;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventCatalogQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventDescription;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventIterator;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.RunProperties;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.VersionHistory;
import edu.sc.seis.sod.model.common.Area;
import edu.sc.seis.sod.model.common.BoxAreaImpl;
import edu.sc.seis.sod.model.common.GlobalAreaImpl;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.ParameterRef;
import edu.sc.seis.sod.model.common.PointDistanceAreaImpl;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.FlinnEngdahlRegion;
import edu.sc.seis.sod.model.event.FlinnEngdahlType;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.source.event.AbstractEventSource;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.subsetter.origin.Catalog;
import edu.sc.seis.sod.subsetter.origin.Contributor;
import edu.sc.seis.sod.subsetter.origin.MagnitudeRange;
import edu.sc.seis.sod.subsetter.origin.OriginDepthRange;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FdsnEvent
extends AbstractEventSource
implements EventSource {
    FDSNEventQueryParams queryParams = new FDSNEventQueryParams();
    MicroSecondTimeRangeSupplier eventTimeRangeSupplier;
    private Instant lastQueryEnd;
    private Instant nextLastQueryEnd;
    String url;
    int port = -1;
    URI parsedURL;
    int increaseThreashold = 10;
    int decreaseThreashold = 100;
    private static final Logger logger = LoggerFactory.getLogger(FdsnEvent.class);
    public static final String URL_ELEMENT = "url";
    public static final String HOST_ELEMENT = "host";
    public static final String PORT_ELEMENT = "port";
    public static final String SCHEME_ELEMENT = "scheme";
    public static final String BAD_PARAM_MESSAGE = "The remote web service just indicated that the query was badly formed. This may be because it does not support all of the parameters that SOD uses or it could be a bug in SOD. Check your recipe and if you cannot figure it out contact the developers at sod@seis.sc.edu. ";
    String userAgent = "SOD/" + VersionHistory.current().getVersion();

    public FdsnEvent(final FDSNEventQueryParams queryParams) {
        super("DefaultFDSNEvent", 2);
        this.eventTimeRangeSupplier = new MicroSecondTimeRangeSupplier(){

            @Override
            public TimeRange getMSTR() {
                return new TimeRange(TimeUtils.parseISOString((String)queryParams.getParam("starttime")), TimeUtils.parseISOString((String)queryParams.getParam("endtime")));
            }
        };
        this.queryParams = queryParams;
    }

    public FdsnEvent(Element config) throws ConfigurationException {
        super(config, "DefaultFDSNEvent");
        String fdsnwsPath;
        String scheme;
        String host;
        this.queryParams.setIncludeAllMagnitudes(true).setOrderBy("time-asc");
        int port = SodUtil.loadInt(config, PORT_ELEMENT, -1);
        if (port > 0) {
            this.queryParams.setPort(port);
        }
        if ((host = SodUtil.loadText(config, HOST_ELEMENT, null)) != null && host.length() != 0) {
            this.queryParams.setHost(host);
        }
        if ((scheme = SodUtil.loadText(config, SCHEME_ELEMENT, null)) != null && scheme.length() != 0) {
            this.queryParams.setScheme(scheme);
            if (port == -1) {
                if (scheme.equalsIgnoreCase("http")) {
                    this.queryParams.setPort(80);
                }
                if (scheme.equalsIgnoreCase("https")) {
                    this.queryParams.setPort(443);
                }
            }
        }
        if ((fdsnwsPath = SodUtil.loadText(config, "fdsnwsPath", null)) != null && fdsnwsPath.length() != 0) {
            this.queryParams.setFdsnwsPath(fdsnwsPath);
        }
        boolean foundCatalog = false;
        boolean foundContributor = false;
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            String tagName;
            Node node = childNodes.item(counter);
            if (!(node instanceof Element) || (tagName = ((Element)node).getTagName()).equals("retries") || tagName.equals("fdsnwsPath") || tagName.equals("refreshInterval") || tagName.equals("eventQueryIncrement") || tagName.equals("eventLag") || tagName.equals(HOST_ELEMENT) || tagName.equals(PORT_ELEMENT) || tagName.equals(SCHEME_ELEMENT) || tagName.equals("name")) continue;
            Object object = SodUtil.load((Element)node, new String[]{"eventArm", "origin"});
            if (tagName.equals("originTimeRange")) {
                this.eventTimeRangeSupplier = (MicroSecondTimeRangeSupplier)SodUtil.load((Element)node, new String[]{"eventArm", "origin"});
                continue;
            }
            if (tagName.equals("originDepthRange")) {
                OriginDepthRange dr = (OriginDepthRange)object;
                if (dr.getMinDepth().getValue(UnitImpl.KILOMETER) > -99999.0) {
                    this.queryParams.setMinDepth((float)dr.getMinDepth().getValue(UnitImpl.KILOMETER));
                }
                if (!(dr.getMaxDepth().getValue(UnitImpl.KILOMETER) < 99999.0)) continue;
                this.queryParams.setMaxDepth((float)dr.getMaxDepth().getValue(UnitImpl.KILOMETER));
                continue;
            }
            if (tagName.equals("magnitudeRange")) {
                MagnitudeRange magRange = (MagnitudeRange)object;
                String[] magTypes = magRange.getSearchTypes();
                Object magStr = "";
                for (int i = 0; i < magTypes.length; ++i) {
                    magStr = (String)magStr + magTypes[i];
                    if (i >= magTypes.length - 1) continue;
                    magStr = (String)magStr + ",";
                }
                if (((String)magStr).length() != 0) {
                    this.queryParams.setMagnitudeType((String)magStr);
                    EventArm eArm = Start.getEventArm();
                    if (eArm != null) {
                        eArm.getSubsetters().add(0, magRange);
                    }
                } else if (this.queryParams.getHost().equals("service.iris.edu")) {
                    this.queryParams.setMagnitudeType("preferred");
                }
                if (magRange.getMinValue() > -99.0) {
                    this.queryParams.setMinMagnitude((float)magRange.getMinValue());
                }
                if (!(magRange.getMaxValue() < 99.0)) continue;
                this.queryParams.setMaxMagnitude((float)magRange.getMaxValue());
                continue;
            }
            if (object instanceof Area) {
                Area area = (Area)object;
                if (area instanceof GlobalAreaImpl) continue;
                if (area instanceof BoxAreaImpl) {
                    BoxAreaImpl box = (BoxAreaImpl)area;
                    this.queryParams.area(box.min_latitude, box.max_latitude, box.min_longitude, box.max_longitude);
                    continue;
                }
                if (area instanceof PointDistanceAreaImpl) {
                    PointDistanceAreaImpl donut = (PointDistanceAreaImpl)area;
                    if (donut.minradius > 0.0f) {
                        this.queryParams.donut((DonutArea)donut);
                        continue;
                    }
                    this.queryParams.ring(donut.latitude, donut.longitude, donut.maxradius);
                    continue;
                }
                throw new ConfigurationException("Area of class " + area.getClass().getName() + " not understood");
            }
            if (tagName.equals("catalog")) {
                foundCatalog = true;
                this.queryParams.setCatalog(((Catalog)object).getCatalog());
                continue;
            }
            if (!tagName.equals("contributor")) continue;
            this.queryParams.setContributor(((Contributor)object).getContributor());
            foundContributor = true;
            for (int c = 0; c < childNodes.getLength(); ++c) {
                Node cnode = childNodes.item(counter);
                if (!(cnode instanceof Element) || !((Element)cnode).getTagName().equals("catalog")) continue;
                foundCatalog = true;
            }
            if (foundCatalog || !this.queryParams.getHost().equals("service.iris.edu")) continue;
            this.fixCatalogForContributor(((Contributor)object).getContributor());
        }
        try {
            if (foundContributor) {
                FDSNEventCatalogQuerier querier = new FDSNEventCatalogQuerier(this.queryParams);
                querier.setUserAgent(this.getUserAgent());
                logger.info("contributor URL: " + String.valueOf(querier.formURI()));
                this.checkAgainstKnownServer("contributor", querier.getContributors());
                return;
            }
            if (foundCatalog) {
                FDSNEventCatalogQuerier querier = new FDSNEventCatalogQuerier(this.queryParams);
                querier.setUserAgent(this.getUserAgent());
                logger.info("catalog URL: " + String.valueOf(querier.formURI()));
                this.checkAgainstKnownServer("catalog", querier.getCatalogs());
                return;
            }
        }
        catch (FDSNWSException e) {
            throw new ConfigurationException("Trouble verifying catalog/contributor with server", e);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Trouble verifying catalog/contributor with server", e);
        }
    }

    private void checkAgainstKnownServer(String askStyle, List<String> contribList) {
        String askCatalog = this.queryParams.getParam(askStyle);
        if (!contribList.contains(askCatalog)) {
            Object knownCatalogs = "";
            for (String c : contribList) {
                knownCatalogs = (String)knownCatalogs + c + ", ";
            }
            knownCatalogs = ((String)knownCatalogs).substring(0, ((String)knownCatalogs).length() - 2);
            Start.informUserOfBadQueryAndExit("You asked for events from the " + askCatalog + " " + askStyle + " but the server does not think it has that " + askStyle + ". Known " + askStyle + "s are: " + (String)knownCatalogs + ".", null);
        }
    }

    private void fixCatalogForContributor(String contributor) {
        if (contributor.contains("NEIC")) {
            this.queryParams.setCatalog("NEIC PDE");
        } else if (contributor.contains("GCMT")) {
            this.queryParams.setCatalog("GCMT");
        } else if (contributor.contains("ISC")) {
            this.queryParams.setCatalog("ISC");
        } else if (contributor.contains("ANF")) {
            this.queryParams.setCatalog("ANF");
        } else if (contributor.equals("University of Washington")) {
            this.queryParams.setCatalog("UofW");
        }
    }

    @Override
    public boolean hasNext() {
        Instant queryEnd = this.getEventTimeRange().getEndTime();
        Instant quitDate = queryEnd.plus(this.lag);
        boolean out = quitDate.equals(ClockUtil.now()) || quitDate.isAfter(ClockUtil.now()) || !this.getQueryStart().equals(queryEnd);
        logger.debug(this.getName() + " Checking if more queries to the event server are in order.  The quit date is " + String.valueOf(quitDate) + " the last query was for " + String.valueOf(this.getQueryStart()) + " and we're querying to " + String.valueOf(queryEnd) + " result=" + out);
        return out;
    }

    @Override
    public CacheEvent[] next() {
        TimeRange queryTime = this.getQueryTime();
        logger.debug(this.getName() + ".next() called for " + String.valueOf(queryTime));
        logger.debug("eventTimeRangeSupplier.getMSTR(): " + String.valueOf(this.eventTimeRangeSupplier.getMSTR()));
        int count = 0;
        Throwable latest = null;
        while (count == 0 || this.getRetryStrategy().shouldRetry(latest, this, count)) {
            Throwable rootCause;
            try {
                List<CacheEvent> result = this.internalNext(queryTime);
                if (++count > 1) {
                    this.getRetryStrategy().serverRecovered(this);
                }
                return result.toArray(new CacheEvent[0]);
            }
            catch (SeisFileException e) {
                ++count;
                latest = e;
                rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)e);
                if (rootCause instanceof IOException) {
                    if (!(rootCause instanceof SocketTimeoutException) && !(rootCause instanceof InterruptedIOException)) continue;
                    if (this.getIncrement().toNanos() > MIN_INCREMENT.toNanos()) {
                        this.decreaseQueryTimeWidth();
                        if (this.increaseThreashold > 2) {
                            this.increaseThreashold /= 2;
                        }
                    }
                    return new CacheEvent[0];
                }
                if (e instanceof FDSNWSException && ((FDSNWSException)((Object)e)).getHttpResponseCode() != 200) {
                    latest = e;
                    if (((FDSNWSException)((Object)e)).getHttpResponseCode() != 400) continue;
                    Start.simpleArmFailure(Start.getEventArm(), "The remote web service just indicated that the query was badly formed. This may be because it does not support all of the parameters that SOD uses or it could be a bug in SOD. Check your recipe and if you cannot figure it out contact the developers at sod@seis.sc.edu.  " + ((FDSNWSException)((Object)e)).getMessage() + " on " + String.valueOf(((FDSNWSException)((Object)e)).getTargetURI()));
                    continue;
                }
                throw new RuntimeException(e);
            }
            catch (XMLStreamException e) {
                ++count;
                latest = e;
                rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)e);
                if (rootCause instanceof IOException) {
                    if (!(rootCause instanceof SocketTimeoutException)) continue;
                    if (this.getIncrement().toNanos() > MIN_INCREMENT.toNanos()) {
                        this.decreaseQueryTimeWidth();
                        if (this.increaseThreashold > 2) {
                            this.increaseThreashold /= 2;
                        }
                    }
                    return new CacheEvent[0];
                }
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw new RuntimeException(latest);
    }

    public List<CacheEvent> internalNext(TimeRange queryTime) throws SeisFileException, XMLStreamException {
        try {
            ArrayList<CacheEvent> out = new ArrayList<CacheEvent>();
            FDSNEventQuerier querier = this.getQuakeMLQuerier(this.setUpQuery(queryTime));
            Quakeml qml = querier.getQuakeML();
            EventIterator it = qml.getEventParameters().getEvents();
            if (!it.hasNext()) {
                logger.debug("No events returned from query.");
            }
            while (it.hasNext()) {
                Event e = it.next();
                out.add(FdsnEvent.toCacheEvent(e));
            }
            qml.close();
            if (!this.caughtUpWithRealtime()) {
                if (out.size() < this.increaseThreashold) {
                    this.increaseQueryTimeWidth();
                }
                if (out.size() > this.decreaseThreashold) {
                    this.decreaseQueryTimeWidth();
                }
            }
            this.updateQueryEdge(queryTime);
            return out;
        }
        catch (SeisFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeisFileException((Throwable)e);
        }
    }

    @Override
    public TimeRange getEventTimeRange() {
        return this.eventTimeRangeSupplier.getMSTR();
    }

    static CacheEvent toCacheEvent(Event e) {
        String desc = "";
        if (e.getDescriptionList().size() > 0) {
            desc = ((EventDescription)e.getDescriptionList().get(0)).getText();
        }
        FlinnEngdahlRegion fe = new FlinnEngdahlRegion(FlinnEngdahlType.GEOGRAPHIC_REGION, 0);
        for (EventDescription eDescription : e.getDescriptionList()) {
            if (eDescription.getIrisFECode() == -1) continue;
            fe = new FlinnEngdahlRegion(FlinnEngdahlType.GEOGRAPHIC_REGION, eDescription.getIrisFECode());
        }
        ArrayList<OriginImpl> out = new ArrayList<OriginImpl>();
        HashMap magsByOriginId = new HashMap();
        List mList = e.getMagnitudeList();
        Object prefMag = null;
        for (Object m : mList) {
            if (!magsByOriginId.containsKey(m.getOriginId())) {
                magsByOriginId.put(m.getOriginId(), new ArrayList());
            }
            ((List)magsByOriginId.get(m.getOriginId())).add(m);
            if (!m.getPublicId().equals(e.getPreferredMagnitudeID())) continue;
            prefMag = m;
        }
        OriginImpl pref = null;
        for (Origin o : e.getOriginList()) {
            ArrayList oMags = (ArrayList)magsByOriginId.get(o.getPublicId());
            if (oMags == null) {
                oMags = new ArrayList();
            }
            ArrayList<Magnitude> fisMags = new ArrayList<Magnitude>();
            for (edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude m : oMags) {
                if (m.getMag() == null) continue;
                fisMags.add(FdsnEvent.toFissuresMagnitude(m));
            }
            if (o.getLatitude() != null && o.getLongitude() != null && o.getTime() != null) {
                QuantityImpl depth = new QuantityImpl(o.getDepth().getValue().floatValue(), UnitImpl.METER);
                OriginImpl oImpl = new OriginImpl(o.getPublicId(), o.getIrisCatalog(), o.getIrisContributor(), TimeUtils.parseISOString((String)o.getTime().getValue()), new Location(o.getLatitude().getValue().floatValue(), o.getLongitude().getValue().floatValue(), new QuantityImpl(0.0, UnitImpl.METER), depth), fisMags.toArray(new Magnitude[0]), new ParameterRef[0]);
                out.add(oImpl);
                if (!o.getPublicId().equals(e.getPreferredOriginID())) continue;
                pref = oImpl;
                continue;
            }
            logger.info("Can't create origin due to NULL: id:" + o.getPublicId() + " lat:" + String.valueOf(o.getLatitude()) + " long:" + String.valueOf(o.getLongitude()) + " time:" + String.valueOf(o.getTime()) + ", skipping.");
        }
        if (prefMag != null && !e.getPreferredMagnitudeID().equals(e.getPreferredOriginID())) {
            Magnitude pm = FdsnEvent.toFissuresMagnitude(prefMag);
            ArrayList<Magnitude> newMags = new ArrayList<Magnitude>();
            newMags.add(pm);
            newMags.addAll(pref.getMagnitudeList());
            Iterator it = newMags.iterator();
            it.next();
            while (it.hasNext()) {
                Magnitude fm = (Magnitude)it.next();
                if (!fm.type.equals(pm.type) || fm.value != pm.value || !fm.contributor.equals(pm.contributor)) continue;
                it.remove();
            }
            pref = new OriginImpl(pref.get_id(), pref.getCatalog(), pref.getContributor(), pref.getOriginTime(), pref.getLocation(), newMags.toArray(new Magnitude[0]), pref.getParmIds());
        }
        CacheEvent ce = new CacheEvent(new EventAttrImpl(desc, fe), out.toArray(new OriginImpl[0]), pref);
        return ce;
    }

    static Magnitude toFissuresMagnitude(edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude m) {
        String contributor = "";
        if (m.getCreationInfo() != null && m.getCreationInfo().getAuthor() != null) {
            contributor = m.getCreationInfo().getAuthor();
        }
        String type = "";
        if (m.getType() != null) {
            type = m.getType();
        }
        return new Magnitude(type, m.getMag().getValue().floatValue(), contributor);
    }

    FDSNEventQuerier getQuakeMLQuerier(FDSNEventQueryParams timeWindowQueryParams) throws MalformedURLException, IOException, URISyntaxException, XMLStreamException, SeisFileException {
        FDSNEventQuerier querier = new FDSNEventQuerier(timeWindowQueryParams);
        RunProperties runProps = Start.getRunProps();
        if (runProps.getProxyHost() != null) {
            querier.setProxyHost(runProps.getProxyHost());
            querier.setProxyPort(runProps.getProxyPort());
            querier.setProxyProtocol(runProps.getProxyScheme());
        }
        querier.setUserAgent(this.getUserAgent());
        return querier;
    }

    FDSNEventQueryParams setUpQuery(TimeRange queryTime) throws URISyntaxException {
        FDSNEventQueryParams timeWindowQueryParams = this.queryParams.clone();
        timeWindowQueryParams.setStartTime(queryTime.getBeginTime());
        timeWindowQueryParams.setEndTime(queryTime.getEndTime());
        if (this.isEverCaughtUpToRealtime() && this.lastQueryEnd != null) {
            timeWindowQueryParams.setUpdatedAfter(this.lastQueryEnd.minus(Duration.ofHours(10L)));
        }
        logger.debug("Query: " + String.valueOf(timeWindowQueryParams.formURI()));
        return timeWindowQueryParams;
    }

    @Override
    protected Instant resetQueryTimeForLag() {
        Instant out = super.resetQueryTimeForLag();
        this.lastQueryEnd = this.nextLastQueryEnd;
        this.nextLastQueryEnd = ClockUtil.now();
        return out;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

