/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.source.event.AbstractEventSource;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DelayedEventSource
extends AbstractEventSource
implements EventSource {
    String description = null;
    EventSource wrappedSource;
    Duration delay;
    LinkedList<CacheEvent> delayedEvents = new LinkedList();
    private static Logger logger = LoggerFactory.getLogger(DelayedEventSource.class);

    protected DelayedEventSource(Duration delay, EventSource source) {
        super("delayed " + source.getName(), source.getRetries());
        this.delay = delay;
        this.wrappedSource = source;
    }

    public DelayedEventSource(Element config) throws ConfigurationException {
        super(config, "delayedEventSouce");
        this.delay = SodUtil.loadTimeInterval(SodUtil.getElement(config, "delay"));
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Object o;
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            if (el.getLocalName().equals("name")) {
                this.description = SodUtil.getNestedText(el);
                continue;
            }
            if (el.getLocalName().equals("delay") || !((o = SodUtil.load(el, "event")) instanceof EventSource)) continue;
            this.wrappedSource = (EventSource)o;
            break;
        }
    }

    @Override
    public TimeRange getEventTimeRange() {
        return this.wrappedSource.getEventTimeRange();
    }

    @Override
    public Duration getWaitBeforeNext() {
        Duration waitTime = this.wrappedSource.getWaitBeforeNext();
        for (CacheEvent ce : this.delayedEvents) {
            Duration deTime = Duration.between(ClockUtil.now(), ce.getOrigin().getOriginTime().plus(this.delay));
            if (deTime.toNanos() >= waitTime.toNanos()) continue;
            waitTime = deTime;
        }
        return waitTime;
    }

    @Override
    public boolean hasNext() {
        return this.delayedEvents.size() != 0 || this.wrappedSource.hasNext();
    }

    @Override
    public CacheEvent[] next() {
        logger.debug("next: " + this.delayedEvents.size() + " delayed.");
        ArrayList<CacheEvent> out = new ArrayList<CacheEvent>();
        Iterator it = this.delayedEvents.iterator();
        while (it.hasNext()) {
            CacheEvent cacheEvent = (CacheEvent)it.next();
            if (!this.checkEvent(cacheEvent)) continue;
            out.add(cacheEvent);
            it.remove();
        }
        if (out.size() != 0) {
            return out.toArray(new CacheEvent[0]);
        }
        if (this.wrappedSource.hasNext()) {
            CacheEvent[] wrapEvents = this.wrappedSource.next();
            for (int i = 0; i < wrapEvents.length; ++i) {
                if (this.checkEvent(wrapEvents[i])) {
                    out.add(wrapEvents[i]);
                    continue;
                }
                this.delayedEvents.add(wrapEvents[i]);
            }
        }
        return out.toArray(new CacheEvent[0]);
    }

    public boolean checkEvent(CacheEvent e) {
        return ClockUtil.now().minus(this.delay).isAfter(e.getOrigin().getOriginTime());
    }
}

