/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.source.event.AbstractEventSource;
import edu.sc.seis.sod.source.event.EventSource;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BackwardsEventSource
extends AbstractEventSource {
    EventSource wrappedSource;
    private static final Logger logger = LoggerFactory.getLogger(BackwardsEventSource.class);

    protected BackwardsEventSource(EventSource source) {
        super("backwards " + source.getName(), source.getRetries());
        this.wrappedSource = source;
    }

    public BackwardsEventSource(Element config) throws ConfigurationException {
        super(config, "BackwardsEventSource");
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            if (el.getLocalName().equals("name")) {
                this.name = SodUtil.getNestedText(el);
                continue;
            }
            Object o = SodUtil.load(el, "event");
            if (!(o instanceof EventSource)) continue;
            this.wrappedSource = (EventSource)o;
            break;
        }
    }

    @Override
    public TimeRange getEventTimeRange() {
        return this.wrappedSource.getEventTimeRange();
    }

    @Override
    public boolean hasNext() {
        TimeRange currentQuery = this.getQueryTime();
        Instant queryBegin = this.getEventTimeRange().getBeginTime();
        logger.debug("Checking if more queries to the event server are in order. The last query was  " + String.valueOf(currentQuery) + " and we're querying from " + String.valueOf(currentQuery.getBeginTime().minus(this.increment)));
        return !currentQuery.getEndTime().equals(queryBegin);
    }

    @Override
    public CacheEvent[] next() {
        CacheEvent[] results = this.wrappedSource.next();
        CacheEvent[] out = new CacheEvent[results.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = results[results.length - i - 1];
        }
        return out;
    }

    @Override
    protected boolean caughtUpWithRealtime() {
        return false;
    }

    @Override
    protected void updateQueryEdge(TimeRange queryTime) {
        this.setQueryEdge(queryTime.getBeginTime());
    }

    @Override
    protected Instant getQueryStart() {
        try {
            return this.getQueryEdge();
        }
        catch (NotFound e) {
            logger.debug("the query times database didn't have an entry for our server/dns combo, just use the time in the config file");
            return this.getEventTimeRange().getEndTime();
        }
    }

    @Override
    protected TimeRange getQueryTime() {
        Instant queryEnd = this.getQueryStart();
        Instant queryStart = queryEnd.minus(this.increment);
        if (this.getEventTimeRange().getBeginTime().isAfter(queryStart)) {
            queryStart = this.getEventTimeRange().getBeginTime();
        }
        return new TimeRange(queryStart, queryEnd);
    }
}

