/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.QueryTime;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class AbstractEventSource
extends AbstractSource
implements EventSource {
    protected boolean caughtUpToRealtime = false;
    protected boolean everCaughtUpToRealtime = false;
    protected Instant lastQueryTime = null;
    protected Instant sleepUntilTime = null;
    protected Duration increment;
    protected Duration lag;
    protected Duration refreshInterval = Duration.ofMinutes(10L);
    protected Duration nearRealTimeInterval = Duration.ofMinutes(2L);
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventSource.class);
    public static final String EVENT_QUERY_INCREMENT = "eventQueryIncrement";
    public static final String EVENT_REFRESH_INTERVAL = "eventRefreshInterval";
    public static final String EVENT_LAG = "eventLag";
    public static final Duration MIN_INCREMENT = Duration.ofDays(1L);

    public AbstractEventSource(String name, int retries) {
        super(name, retries);
        this.refreshInterval = Start.getRunProps().getEventRefreshInterval();
        this.lag = Start.getRunProps().getEventLag();
        this.increment = Start.getRunProps().getEventQueryIncrement();
    }

    public AbstractEventSource(Element config, String defaultName) throws ConfigurationException {
        super(config, defaultName, -1);
        this.refreshInterval = DOMHelper.hasElement(config, "refreshInterval") ? SodUtil.loadTimeInterval(SodUtil.getElement(config, "refreshInterval")) : Start.getRunProps().getEventRefreshInterval();
        this.increment = DOMHelper.hasElement(config, EVENT_QUERY_INCREMENT) ? SodUtil.loadTimeInterval(SodUtil.getElement(config, EVENT_QUERY_INCREMENT)) : Start.getRunProps().getEventQueryIncrement();
        this.lag = DOMHelper.hasElement(config, EVENT_LAG) ? SodUtil.loadTimeInterval(SodUtil.getElement(config, EVENT_LAG)) : Start.getRunProps().getEventLag();
    }

    @Override
    public Duration getWaitBeforeNext() {
        Duration sleepTime;
        Instant now = ClockUtil.now();
        if (!this.caughtUpWithRealtime()) {
            return Duration.ofSeconds(0L);
        }
        if (this.lastQueryTime == null) {
            this.lastQueryTime = now.minus(this.refreshInterval).minus(this.nearRealTimeInterval);
        }
        if ((sleepTime = Duration.between(this.lastQueryTime, now).plus(this.refreshInterval)).toNanos() < 0L) {
            this.caughtUpToRealtime = false;
        }
        logger.debug("getWaitBeforeNext() lq=" + String.valueOf(this.lastQueryTime) + " sleep=" + TimeUtils.durationToDoubleSeconds((Duration)sleepTime) + "  now=" + String.valueOf(now) + "  refesh=" + TimeUtils.durationToDoubleSeconds((Duration)this.refreshInterval));
        return sleepTime;
    }

    protected boolean caughtUpWithRealtime() {
        return this.caughtUpToRealtime;
    }

    protected boolean isEverCaughtUpToRealtime() {
        return this.everCaughtUpToRealtime;
    }

    protected Instant getQueryStart() {
        try {
            return this.getQueryEdge();
        }
        catch (NotFound e) {
            logger.debug("the query times database didn't have an entry for our server/dns combo, just use the time in the config file");
            this.setQueryEdge(this.getEventTimeRange().getBeginTime());
            return this.getEventTimeRange().getBeginTime();
        }
    }

    protected TimeRange getQueryTime() {
        Instant now = ClockUtil.now();
        Instant queryStart = this.getQueryStart();
        if (this.caughtUpWithRealtime()) {
            queryStart = this.resetQueryTimeForLag();
            this.caughtUpToRealtime = false;
        }
        Instant queryEnd = queryStart.plus(this.increment);
        if (this.getEventTimeRange().getEndTime().isBefore(queryEnd)) {
            queryEnd = this.getEventTimeRange().getEndTime();
            logger.debug("Caught up with edge of event time range.");
            this.caughtUpToRealtime = true;
            this.everCaughtUpToRealtime = true;
        }
        if (now.isBefore(queryEnd)) {
            logger.info("Caught up with now.");
            queryEnd = now;
            this.caughtUpToRealtime = true;
            this.everCaughtUpToRealtime = true;
        }
        if (queryStart.isAfter(ClockUtil.wayFuture())) {
            throw new RuntimeException("start way in future: qs=" + String.valueOf(queryStart) + " lag=" + String.valueOf(this.getLag()) + " end=" + String.valueOf(queryEnd));
        }
        if (Duration.between(queryStart, queryEnd).toNanos() < TimeUtils.ONE_MINUTE.toNanos()) {
            logger.warn("Query for very short time window: start:" + String.valueOf(queryStart) + " end:" + String.valueOf(queryEnd) + " inc:" + String.valueOf(this.increment) + " now:" + String.valueOf(now) + "  cuwrt:" + this.caughtUpToRealtime + " ecuwrt:" + this.everCaughtUpToRealtime + "  tot end:" + String.valueOf(this.getEventTimeRange().getEndTime()));
        }
        return new TimeRange(queryStart, queryEnd);
    }

    public void increaseQueryTimeWidth() {
        this.increment = this.increment.multipliedBy(2L);
    }

    public void decreaseQueryTimeWidth() {
        if (this.getIncrement().toNanos() > MIN_INCREMENT.toNanos()) {
            this.increment = Duration.ofNanos(Math.round(0.75 * (double)this.increment.toNanos()));
        }
    }

    protected Instant resetQueryTimeForLag() {
        Instant newEdge = this.getQueryStart().minus(this.lag);
        if (newEdge.isBefore(this.getEventTimeRange().getBeginTime())) {
            newEdge = this.getEventTimeRange().getBeginTime();
        }
        return newEdge;
    }

    protected Instant getQueryEdge() throws NotFound {
        SodDB sdb = SodDB.getSingleton();
        QueryTime t = sdb.getQueryTime(this.getName());
        SodDB.commit();
        if (t == null) {
            throw new NotFound();
        }
        return t.getTime();
    }

    protected void setQueryEdge(Instant edge) {
        this.lastQueryTime = ClockUtil.now();
        SodDB sdb = SodDB.getSingleton();
        QueryTime qt = sdb.getQueryTime(this.getName());
        if (qt != null) {
            qt.setTime(edge);
            SodDB.getSession().saveOrUpdate((Object)qt);
        } else {
            sdb.putQueryTime(new QueryTime(this.getName(), edge));
        }
        SodDB.commit();
    }

    protected void updateQueryEdge(TimeRange queryTime) {
        this.setQueryEdge(queryTime.getEndTime());
    }

    public Instant getSleepUntilTime() {
        return this.sleepUntilTime;
    }

    public Duration getLag() {
        return this.lag;
    }

    public Duration getIncrement() {
        return this.increment;
    }

    public void setIncrement(Duration increment) {
        this.increment = increment;
    }

    public void setLag(Duration lag) {
        this.lag = lag;
    }

    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }
}

