/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source;

import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.UserReportRetryStrategy;
import edu.sc.seis.sod.retry.ClassicRetryStrategy;
import edu.sc.seis.sod.retry.RetryStrategy;
import edu.sc.seis.sod.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class AbstractSource
implements Source {
    protected String name;
    private int retries = -1;
    private RetryStrategy retryStrategy;
    public static final String NAME_ELEMENT = "name";
    public static final String RETRIES_ELEMENT = "retries";
    private static Logger logger = LoggerFactory.getLogger(AbstractSource.class);

    public AbstractSource(String name) {
        this(name, -1);
    }

    public AbstractSource(String name, int retries) {
        this.name = name;
        retries = -1;
        this.retryStrategy = new ClassicRetryStrategy(retries);
    }

    public AbstractSource(Element config, String defaultName) {
        this(config, defaultName, -1);
    }

    public AbstractSource(Element config, String defaultName, int defaultRetries) {
        this.name = config.hasAttribute(NAME_ELEMENT) ? config.getAttribute(NAME_ELEMENT) : SodUtil.loadText(config, NAME_ELEMENT, defaultName);
        this.retries = SodUtil.loadInt(config, RETRIES_ELEMENT, defaultRetries);
        this.retryStrategy = new UserReportRetryStrategy(this.getRetries());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        if (retryStrategy == null) {
            throw new IllegalArgumentException("RetryStrategy cannot be null");
        }
        this.retryStrategy = retryStrategy;
    }

    @Override
    public void appendToName(String suffix) {
        this.name = this.name + suffix;
    }
}

