/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.retry;

import edu.sc.seis.sod.retry.BaseRetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicRetryStrategy
extends BaseRetryStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ClassicRetryStrategy.class);

    public ClassicRetryStrategy(int numRetries) {
        super(numRetries);
    }

    @Override
    public boolean shouldRetry(Throwable exc, Object server, int tryCount) {
        Object tryString = this.numRetries != -1 ? "" + this.numRetries : "infinity";
        String name = server.toString();
        logger.debug("Caught exception on " + name + ", retrying " + tryCount + " of " + (String)tryString, exc);
        return this.basicShouldRetry(exc, server, tryCount);
    }

    @Override
    public void serverRecovered(Object server) {
        String name = server.toString();
        logger.debug(name + " recovered");
    }
}

