/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.retry;

import edu.sc.seis.sod.retry.RetryStrategy;

public abstract class BaseRetryStrategy
implements RetryStrategy {
    int numRetries;
    protected static int defaultTimeoutSeconds = 20;
    protected static int sleepSeconds = 1;
    private static int defaultNumRetry = 3;

    public BaseRetryStrategy(int numRetries) {
        this.numRetries = numRetries;
    }

    @Override
    public abstract boolean shouldRetry(Throwable var1, Object var2, int var3);

    protected boolean basicShouldRetry(Throwable exc, Object server, int tryCount) {
        if (this.numRetries == -1 || tryCount < this.numRetries) {
            BaseRetryStrategy.retrySleep(tryCount);
            return true;
        }
        return false;
    }

    @Override
    public void serverRecovered(Object server) {
    }

    public static void retrySleep(int count) {
        if (count > 1) {
            try {
                if (count > 30) {
                    Thread.sleep((defaultTimeoutSeconds + 300) * sleepSeconds * 1000);
                } else if (count > 10) {
                    Thread.sleep((defaultTimeoutSeconds + 10 * count) * sleepSeconds * 1000);
                } else {
                    Thread.sleep(defaultTimeoutSeconds * sleepSeconds * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static int getDefaultNumRetry() {
        return defaultNumRetry;
    }

    public static void setDefaultNumRetry(int defaultNum) {
        defaultNumRetry = defaultNum;
    }
}

