/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.AbstractScriptSubsetter;
import edu.sc.seis.sod.subsetter.UnknownScriptResult;
import edu.sc.seis.sod.velocity.event.VelocityEvent;
import edu.sc.seis.sod.velocity.network.VelocityChannelGroup;
import edu.sc.seis.sod.velocity.seismogram.VelocityRequest;
import edu.sc.seis.sod.velocity.seismogram.VelocitySeismogram;
import java.util.List;
import org.w3c.dom.Element;

public class VectorScript
extends AbstractScriptSubsetter
implements WaveformVectorProcess {
    public VectorScript(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        return this.runScript(new VelocityEvent(event), new VelocityChannelGroup(channelGroup), VelocityRequest.wrap(original, channelGroup), VelocityRequest.wrap(available, channelGroup), VelocitySeismogram.wrap(seismograms, channelGroup), cookieJar);
    }

    public WaveformVectorResult runScript(VelocityEvent event, VelocityChannelGroup channelGroup, List<List<VelocityRequest>> request, List<List<VelocityRequest>> available, List<List<VelocitySeismogram>> seismograms, MeasurementStorage cookieJar) throws Exception {
        this.engine.put("event", event);
        this.engine.put("channel", channelGroup);
        this.engine.put("request", request);
        this.engine.put("available", available);
        this.engine.put("seismograms", seismograms);
        this.engine.put("cookieJar", cookieJar);
        Object result = this.preeval();
        if (result == null) {
            result = this.engine.get("result");
        }
        if (result == null) {
            return new WaveformVectorResult((LocalSeismogramImpl[][])this.engine.get("seismograms"), new Pass(this));
        }
        if (result instanceof WaveformVectorResult) {
            return (WaveformVectorResult)result;
        }
        if (result instanceof StringTree) {
            return new WaveformVectorResult((LocalSeismogramImpl[][])this.engine.get("seismograms"), (StringTree)result);
        }
        if (result instanceof Boolean) {
            return new WaveformVectorResult((LocalSeismogramImpl[][])this.engine.get("seismograms"), new StringTreeLeaf(this, (boolean)((Boolean)result)));
        }
        throw new UnknownScriptResult("Script returns unknown results type, should be boolean or StringTree or WaveformVectorResult: " + result.toString());
    }
}

