/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.process.waveform.vector.VectorResultWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.StringTreeBranch;
import org.w3c.dom.Element;

public class VectorRetryAndContinue
extends VectorResultWrapper
implements Threadable {
    private SodDB sodDb;

    public VectorRetryAndContinue(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        WaveformVectorResult result;
        if (this.sodDb == null) {
            this.sodDb = SodDB.getSingleton();
        }
        if (!(result = MotionVectorArm.runProcessorThreadCheck(this.subProcess, event, channelGroup, original, available, seismograms, cookieJar)).isSuccess()) {
            cookieJar.getECP().update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.RETRY));
            return this.wrap(result);
        }
        return result;
    }

    protected WaveformVectorResult wrap(WaveformVectorResult result) {
        return new WaveformVectorResult(result.getSeismograms(), new StringTreeBranch((Object)this, true, result.getReason()));
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

