/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.bag.Rotate;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.process.waveform.vector.VectorTrim;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.StringTreeBranch;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.util.display.EventUtil;
import org.w3c.dom.Element;

public class RotateGCP
implements WaveformVectorProcess,
Threadable {
    private String radialOrientationCode;
    private String transverseOrientationCode;
    private float ninetyDegreeTol = 0.01f;
    private VectorTrim trimmer = new VectorTrim();

    public RotateGCP(Element el) {
        this.radialOrientationCode = DOMHelper.extractText(el, "radialOrientationCode", "R");
        this.transverseOrientationCode = DOMHelper.extractText(el, "transverseOrientationCode", "T");
        this.ninetyDegreeTol = SodUtil.loadFloat(el, "ninetyDegreeTol", this.ninetyDegreeTol);
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        int i;
        int i2;
        WaveformVectorResult trimResult = this.trimmer.accept(event, channelGroup, original, available, seismograms, cookieJar);
        if (!trimResult.isSuccess()) {
            return new WaveformVectorResult(false, trimResult.getSeismograms(), new StringTreeBranch((Object)this, false, trimResult.getReason()));
        }
        seismograms = trimResult.getSeismograms();
        Channel[] horizontal = channelGroup.getHorizontalXY(this.ninetyDegreeTol);
        if (horizontal.length == 0) {
            Orientation o1 = Orientation.of(channelGroup.getChannel1());
            Orientation o2 = Orientation.of(channelGroup.getChannel2());
            Orientation o3 = Orientation.of(channelGroup.getChannel3());
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Channels not rotatable, unable to find horizontals with 90 deg separation: " + o1.azimuth + "/" + o1.dip + " " + o2.azimuth + "/" + o2.dip + " " + o3.azimuth + "/" + o3.dip + " tol=" + this.ninetyDegreeTol));
        }
        if (!Rotate.areRotatable(Orientation.of(horizontal[0]), Orientation.of(horizontal[1]), this.ninetyDegreeTol)) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "horizontal channels not orthogonal with tol=" + this.ninetyDegreeTol + ": xAzimuth=" + Orientation.of((Channel)horizontal[0]).azimuth + " yAzimuth=" + Orientation.of((Channel)horizontal[1]).azimuth));
        }
        int xIndex = -1;
        int yIndex = -1;
        for (i2 = 0; i2 < seismograms.length; ++i2) {
            if (seismograms[i2].length == 0) continue;
            if (ChannelIdUtil.areEqual(seismograms[i2][0].channel_id, horizontal[0])) {
                xIndex = i2;
            }
            if (!ChannelIdUtil.areEqual(seismograms[i2][0].channel_id, horizontal[1])) continue;
            yIndex = i2;
        }
        if (xIndex == -1 || yIndex == -1) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Can't find seismograms to match horizontal channels: xIndex=" + xIndex + " yIndex=" + yIndex));
        }
        if (seismograms[xIndex].length != seismograms[yIndex].length) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Seismogram lengths for horizontal channels don't match: " + seismograms[xIndex].length + " != " + seismograms[yIndex].length));
        }
        for (i2 = 0; i2 < seismograms[xIndex].length; ++i2) {
            if (seismograms[xIndex][i2].getNumPoints() == seismograms[yIndex][i2].getNumPoints()) continue;
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, i2 + " Seismogram num points for horizontal channels don't match: " + seismograms[xIndex][i2].getNumPoints() + " != " + seismograms[yIndex][i2].getNumPoints()));
        }
        Location staLoc = Location.of(horizontal[0]);
        Location eventLoc = EventUtil.extractOrigin(event).getLocation();
        LocalSeismogramImpl[][] out = new LocalSeismogramImpl[seismograms.length][];
        for (i = 0; i < out.length; ++i) {
            out[i] = new LocalSeismogramImpl[seismograms[i].length];
            System.arraycopy(seismograms[i], 0, out[i], 0, out[i].length);
        }
        for (i = 0; i < seismograms[xIndex].length; ++i) {
            LocalSeismogramImpl[] rot = Rotate.rotateGCP(seismograms[xIndex][i], Orientation.of(horizontal[0]), seismograms[yIndex][i], Orientation.of(horizontal[1]), staLoc, eventLoc, this.transverseOrientationCode, this.radialOrientationCode, this.ninetyDegreeTol);
            out[xIndex][i] = rot[0];
            out[yIndex][i] = rot[1];
        }
        channelGroup.makeTransverseAndRadial(xIndex, yIndex, event);
        return new WaveformVectorResult(out, new StringTreeLeaf(this, true));
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

