/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.LocalSeismogramArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.process.waveform.ForkProcess;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.process.waveform.vector.WaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.ShortCircuit;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeBranch;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ORWaveformProcessWrapper
implements WaveformProcessWrapper {
    WaveformProcess subsetter;

    public ORWaveformProcessWrapper(WaveformProcess subsetter) {
        this.subsetter = subsetter;
    }

    public ORWaveformProcessWrapper(Element config) throws ConfigurationException {
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            Node node = childNodes.item(counter);
            if (!(node instanceof Element)) continue;
            Object obj = SodUtil.load((Element)node, "waveform");
            if (obj instanceof WaveformProcess) {
                this.subsetter = (WaveformProcess)obj;
                break;
            }
            throw new ConfigurationException("Object loaded is not an instance of LocalSeismogramProcess: " + obj.getClass().getName());
        }
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        WaveformResult result;
        LocalSeismogramImpl[][] out = new LocalSeismogramImpl[seismograms.length][];
        for (int i = 0; i < seismograms.length; ++i) {
            out[i] = seismograms[i];
        }
        boolean b = false;
        StringTree[] reason = new StringTree[channelGroup.getChannels().length];
        for (int i = 0; !b && i < channelGroup.getChannels().length; b |= result.isSuccess(), ++i) {
            Channel chan = channelGroup.getChannels()[i];
            result = LocalSeismogramArm.runProcessorThreadCheck(this.subsetter, event, chan, original[i], available[i], ForkProcess.copySeismograms(seismograms[i]), cookieJar);
            out[i] = result.getSeismograms();
            reason[i] = result.getReason();
        }
        for (int j = i; j < channelGroup.getChannels().length; ++j) {
            reason[j] = new ShortCircuit(this);
        }
        if (b) {
            return new WaveformVectorResult(out, new StringTreeBranch((Object)this, true, reason));
        }
        return new WaveformVectorResult(seismograms, new StringTreeBranch((Object)this, false, reason));
    }

    public String toString() {
        return "ORLocalSeismogramWrapper(" + this.subsetter.toString() + ")";
    }

    @Override
    public WaveformProcess getWrappedProcess() {
        return this.subsetter;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

