/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.bag.IncompatibleSeismograms;
import edu.sc.seis.sod.bag.IterDecon;
import edu.sc.seis.sod.bag.IterDeconResult;
import edu.sc.seis.sod.bag.Rotate;
import edu.sc.seis.sod.bag.TauPUtil;
import edu.sc.seis.sod.bag.ZeroPowerException;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.measure.ListMeasurement;
import edu.sc.seis.sod.measure.Measurement;
import edu.sc.seis.sod.measure.ScalarMeasurement;
import edu.sc.seis.sod.measure.SeismogramMeasurement;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import edu.sc.seis.sod.process.waveform.MseedWriter;
import edu.sc.seis.sod.process.waveform.SacWriter;
import edu.sc.seis.sod.process.waveform.vector.AbstractWaveformVectorMeasure;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class IterDeconReceiverFunction
extends AbstractWaveformVectorMeasure {
    public static float DEFAULT_GWIDTH = 2.5f;
    public static int DEFAULT_MAXBUMPS = 400;
    public static float DEFAULT_TOL = 0.001f;
    protected float orientationTol = 5.0f;
    protected float gwidth = DEFAULT_GWIDTH;
    protected float tol = DEFAULT_TOL;
    protected int maxBumps = DEFAULT_MAXBUMPS;
    protected String modelName = "prem";
    protected boolean pWave = true;
    protected Duration shift = IterDeconReceiverFunction.getDefaultShift();
    protected Duration pad = IterDeconReceiverFunction.getDefaultShift();
    protected AbstractSeismogramWriter writer;
    public static final Duration DEFAULT_SHIFT = Duration.ofSeconds(10L);
    boolean overwrite = false;
    protected TauPUtil taup;
    IterDecon decon;
    static final Logger logger = LoggerFactory.getLogger(IterDeconReceiverFunction.class);

    public IterDeconReceiverFunction(Element config) throws ConfigurationException, TauModelException {
        super(config);
        this.parseIterDeconConfig(config);
        this.taup = TauPUtil.getTauPUtil(this.modelName);
        this.decon = new IterDecon(this.maxBumps, true, this.tol, this.gwidth);
    }

    public void parseIterDeconConfig(Element config) throws ConfigurationException {
        Element sacWriterElement;
        Element mseedWriterElement;
        Element asciiWriterElement;
        Element toleranceElement;
        Element bumpsElement;
        Element gElement;
        Element phaseNameElement;
        Element modelElement = SodUtil.getElement(config, "modelName");
        if (modelElement != null) {
            this.modelName = SodUtil.getNestedText(modelElement);
        }
        if ((phaseNameElement = SodUtil.getElement(config, "phaseName")) != null) {
            String phaseName = SodUtil.getNestedText(phaseNameElement);
            this.pWave = phaseName.equals("P");
        }
        if ((gElement = SodUtil.getElement(config, "gaussianWidth")) != null) {
            String gwidthStr = SodUtil.getNestedText(gElement);
            this.gwidth = Float.parseFloat(gwidthStr);
        }
        if ((bumpsElement = SodUtil.getElement(config, "maxBumps")) != null) {
            String bumpsStr = SodUtil.getNestedText(bumpsElement);
            this.maxBumps = Integer.parseInt(bumpsStr);
        }
        if ((toleranceElement = SodUtil.getElement(config, "tolerance")) != null) {
            String toleranceStr = SodUtil.getNestedText(toleranceElement);
            this.tol = Float.parseFloat(toleranceStr);
        }
        if ((asciiWriterElement = SodUtil.getElement(config, "asciiWriter")) != null) {
            SacWriter sac = new SacWriter(asciiWriterElement);
            this.writer = sac;
        }
        if ((mseedWriterElement = SodUtil.getElement(config, "mseedWriter")) != null) {
            MseedWriter mseed = new MseedWriter(mseedWriterElement);
            this.writer = mseed;
        }
        if ((sacWriterElement = SodUtil.getElement(config, "sacWriter")) != null) {
            SacWriter sac = new SacWriter(sacWriterElement);
            this.writer = sac;
        }
    }

    @Override
    Measurement calculate(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        String[] stringArray;
        Channel chan = channelGroup.getChannels()[0];
        OriginImpl origin = event.get_preferred_origin();
        ChannelId[] chanIds = new ChannelId[channelGroup.getChannels().length];
        for (int i = 0; i < chanIds.length; ++i) {
            chanIds[i] = ChannelId.of(channelGroup.getChannels()[i]);
        }
        LocalSeismogramImpl[] singleSeismograms = new LocalSeismogramImpl[3];
        for (int i = 0; i < singleSeismograms.length; ++i) {
            singleSeismograms[i] = seismograms[i][0];
        }
        IterDeconResult[] ans = this.process(event, channelGroup, singleSeismograms);
        if (this.pWave) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "ttp";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "tts";
        }
        String[] phaseName = stringArray;
        List<Arrival> pPhases = this.taup.calcTravelTimes(chan.getStation(), origin, phaseName);
        Instant firstP = origin.getOriginTime();
        firstP = firstP.plus(ClockUtil.durationFrom(pPhases.get(0).getTime(), UnitImpl.SECOND));
        Duration shift = this.getShift();
        ArrayList<Measurement> measurementList = new ArrayList<Measurement>();
        for (int i = 0; i < ans.length; ++i) {
            float[] predicted = ans[i].getPredicted();
            String chanCode = i == 0 ? "ITR" : "ITT";
            Location staLoc = Location.of(channelGroup.getStation());
            double az = i == 0 ? Rotate.getRadialAzimuth(staLoc, event.getPreferred().getLocation()) : Rotate.getTransverseAzimuth(staLoc, event.getPreferred().getLocation());
            LocalSeismogramImpl rfSeis = this.saveTimeSeries(predicted, "receiver function " + singleSeismograms[0].channel_id.getStationCode(), chanCode, firstP.minus(shift), singleSeismograms[0], UnitImpl.DIMENSONLESS, new Orientation((float)az, 0.0f), event, channelGroup, original, available, cookieJar);
            String mName = i == 0 ? "radial" : "transverse";
            measurementList.add(new SeismogramMeasurement(mName, rfSeis));
            measurementList.add(new ScalarMeasurement(mName + "_percentMatch", ans[i].getPercentMatch()));
        }
        return new ListMeasurement(this.getName(), measurementList);
    }

    public IterDeconResult[] process(CacheEvent event, ChannelGroup channelGroup, LocalSeismogramImpl[] localSeis) throws NoPreferredOrigin, FissuresException, IncompatibleSeismograms, TauPException, ZeroPowerException {
        IterDeconResult ansTangential;
        IterDeconResult ansRadial;
        float[] zdata;
        Channel[] xyChan = channelGroup.getHorizontalXY();
        if (xyChan.length < 2) {
            throw new IncompatibleSeismograms("Unable to find horizontal channels: " + channelGroup.getChannel1().getCode() + " " + channelGroup.getChannel2().getCode() + " " + channelGroup.getChannel3().getCode());
        }
        Channel xChan = xyChan[0];
        Channel yChan = xyChan[1];
        Channel zChan = channelGroup.getVertical();
        if (yChan == null || xChan == null || zChan == null) {
            logger.error("problem one channel component is null ");
            throw new NullPointerException("problem one channel component is null,  " + (yChan != null) + " " + (xChan != null) + " " + (zChan != null));
        }
        LocalSeismogramImpl ySeis = null;
        LocalSeismogramImpl xSeis = null;
        LocalSeismogramImpl zSeis = null;
        Object foundChanCodes = "";
        for (int i = 0; i < localSeis.length; ++i) {
            if (ChannelIdUtil.areEqual(localSeis[i].channel_id, ChannelId.of(yChan))) {
                ySeis = localSeis[i];
            } else if (ChannelIdUtil.areEqual(localSeis[i].channel_id, xChan)) {
                xSeis = localSeis[i];
            } else if (ChannelIdUtil.areEqual(localSeis[i].channel_id, zChan)) {
                zSeis = localSeis[i];
            }
            foundChanCodes = (String)foundChanCodes + localSeis[i].channel_id.getChannelCode() + " ";
        }
        if (ySeis == null || xSeis == null || zSeis == null) {
            logger.error("problem one seismogram component is null ");
            throw new NullPointerException("problem one seismogram component is null, " + (String)foundChanCodes + "  " + (ySeis != null) + " " + (xSeis != null) + " " + (zSeis != null));
        }
        Location staLoc = Location.of(zChan.getStation());
        OriginImpl origin = event.get_preferred_origin();
        Location evtLoc = origin.getLocation();
        LocalSeismogramImpl[] rotSeis = Rotate.rotateGCP(xSeis, Orientation.of(xChan), ySeis, Orientation.of(yChan), staLoc, evtLoc, "T", "R");
        float[][] rotated = new float[][]{rotSeis[0].get_as_floats(), rotSeis[1].get_as_floats()};
        if (rotated[0].length != (zdata = zSeis.get_as_floats()).length) {
            logger.error("data is not of same length " + rotated[0].length + " " + zdata.length);
            throw new IncompatibleSeismograms("data is not of same length " + rotated[0].length + " " + zdata.length);
        }
        if (zdata.length == 0) {
            throw new IncompatibleSeismograms("data is of zero length ");
        }
        SamplingImpl samp = zSeis.sampling_info;
        double period = TimeUtils.durationToDoubleSeconds((Duration)samp.getPeriod());
        zdata = IterDecon.makePowerTwo(zdata);
        rotated[0] = IterDecon.makePowerTwo(rotated[0]);
        rotated[1] = IterDecon.makePowerTwo(rotated[1]);
        if (this.pWave) {
            ansRadial = this.processComponent(rotated[1], zdata, (float)period, staLoc, origin);
            ansTangential = this.processComponent(rotated[0], zdata, (float)period, staLoc, origin);
        } else {
            ansRadial = this.processComponent(zdata, rotated[1], (float)period, staLoc, origin);
            ansTangential = this.processComponent(zdata, rotated[0], (float)period, staLoc, origin);
        }
        IterDeconResult[] ans = new IterDeconResult[]{ansRadial, ansTangential};
        return ans;
    }

    public IterDeconResult processComponent(float[] component, float[] zdata, float period, Location staLoc, OriginImpl origin) throws TauPException, ZeroPowerException {
        String[] stringArray;
        if (component.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Component length is " + component.length);
        }
        if (zdata.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Z component length is " + zdata.length);
        }
        IterDeconResult ans = this.decon.process(component, zdata, period);
        float[] predicted = ans.getPredicted();
        logger.info("predicted.length = " + predicted.length);
        if (this.pWave) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "ttp";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "tts";
        }
        String[] phaseName = stringArray;
        List<Arrival> pPhases = this.taup.calcTravelTimes(staLoc, origin, phaseName);
        Instant firstP = origin.getOriginTime();
        logger.debug("origin " + String.valueOf(firstP));
        firstP = firstP.plus(ClockUtil.durationFrom(pPhases.get(0).getTime(), UnitImpl.SECOND));
        logger.debug("firstP " + String.valueOf(firstP));
        if (this.shift.toNanos() != 0L) {
            logger.debug("shifting by " + String.valueOf(this.shift) + "  before 0=" + predicted[0]);
            predicted = IterDecon.phaseShift(predicted, (float)TimeUtils.durationToDoubleSeconds((Duration)this.shift), period);
            logger.debug("shifting by " + String.valueOf(this.shift));
        }
        logger.info("Finished with receiver function processing");
        logger.debug("rec func begin " + String.valueOf(firstP.minus(this.shift)));
        ans.predicted = predicted;
        ans.setAlignShift(this.shift);
        return ans;
    }

    public LocalSeismogramImpl saveTimeSeries(float[] data, String name, String chanCode, Instant begin, LocalSeismogramImpl refSeismogram, UnitImpl unit, Orientation orientation, CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, MeasurementStorage cookieJar) throws Exception {
        ChannelId recFuncChanId = new ChannelId(refSeismogram.channel_id.getNetworkId(), refSeismogram.channel_id.getStationCode(), refSeismogram.channel_id.getLocCode(), chanCode, refSeismogram.channel_id.getStartTime());
        Channel recFuncChan = new Channel(channelGroup.getChannel1().getStation(), refSeismogram.channel_id.getLocCode(), chanCode);
        recFuncChan.setAzimuth(orientation.getAzimuth());
        recFuncChan.setDip(orientation.getDip());
        recFuncChan.setStartDateTime(channelGroup.getChannel1().getStartDateTime());
        recFuncChan.setEndDateTime(channelGroup.getChannel1().getEndDateTime());
        recFuncChan.setSampleRate(channelGroup.getChannel1().getSampleRate());
        recFuncChan.setLatitude(channelGroup.getChannel1().getLatitude());
        recFuncChan.setLongitude(channelGroup.getChannel1().getLongitude());
        recFuncChan.setElevation(channelGroup.getChannel1().getElevation());
        recFuncChan.setDepth(channelGroup.getChannel1().getDepth());
        recFuncChan.setDescription(name);
        LocalSeismogramImpl predSeis = new LocalSeismogramImpl("recFunc/" + chanCode + "/" + refSeismogram.get_id(), begin, data.length, refSeismogram.sampling_info, unit, recFuncChanId, data);
        predSeis.setName(name);
        if (this.writer != null) {
            this.writer.accept(event, recFuncChan, original[0], available[0], new LocalSeismogramImpl[]{predSeis}, cookieJar);
        }
        return predSeis;
    }

    public float getGwidth() {
        return this.gwidth;
    }

    public float getTol() {
        return this.tol;
    }

    public int getMaxBumps() {
        return this.maxBumps;
    }

    public boolean ispWave() {
        return this.pWave;
    }

    public Duration getShift() {
        return this.shift;
    }

    public Duration getPad() {
        return this.pad;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public static Duration getDefaultShift() {
        return DEFAULT_SHIFT;
    }

    public boolean isThreadSafe() {
        return true;
    }
}

