/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.measure.Measurement;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import org.w3c.dom.Element;

public abstract class AbstractWaveformVectorMeasure
implements WaveformVectorProcess {
    protected String name;

    public AbstractWaveformVectorMeasure(Element config) {
        this.name = SodUtil.loadText(config, "name", SodUtil.getSimpleName(this.getClass()));
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        if (seismograms.length != 0) {
            Measurement m = this.calculate(event, channelGroup, original, available, seismograms, cookieJar);
            cookieJar.addMeasurement(m.getName(), m.getValueJSON());
            return new WaveformVectorResult(seismograms, new Pass(this));
        }
        return new WaveformVectorResult(seismograms, new Fail(this));
    }

    public String getName() {
        return this.name;
    }

    abstract Measurement calculate(CacheEvent var1, ChannelGroup var2, RequestFilter[][] var3, RequestFilter[][] var4, LocalSeismogramImpl[][] var5, MeasurementStorage var6) throws Exception;
}

