/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.LocalSeismogramArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.process.waveform.ForkProcess;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.process.waveform.vector.WaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.ShortCircuit;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeBranch;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ANDWaveformProcessWrapper
implements WaveformProcessWrapper {
    WaveformProcess process;

    public ANDWaveformProcessWrapper(WaveformProcess subsetter) {
        this.process = subsetter;
    }

    public ANDWaveformProcessWrapper(Element config) throws ConfigurationException {
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            Node node = childNodes.item(counter);
            if (!(node instanceof Element)) continue;
            this.process = (WaveformProcess)SodUtil.load((Element)node, "waveform");
            break;
        }
    }

    public WaveformProcess getProcess() {
        return this.process;
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        WaveformResult result;
        LocalSeismogramImpl[][] out = new LocalSeismogramImpl[seismograms.length][];
        boolean b = true;
        StringTree[] reason = new StringTree[channelGroup.getChannels().length];
        for (int i = 0; b && i < channelGroup.getChannels().length; b &= result.isSuccess(), ++i) {
            LocalSeismogramImpl[] copies = ForkProcess.copySeismograms(seismograms[i]);
            Channel chan = channelGroup.getChannels()[i];
            result = LocalSeismogramArm.runProcessorThreadCheck(this.process, event, chan, original[i], available[i], copies, cookieJar);
            out[i] = result.getSeismograms();
            reason[i] = result.getReason();
        }
        for (int j = i + 1; j < channelGroup.getChannels().length; ++j) {
            reason[j] = new ShortCircuit(this);
        }
        if (!b) {
            return new WaveformVectorResult(seismograms, new StringTreeBranch((Object)this, false, reason));
        }
        return new WaveformVectorResult(out, new StringTreeBranch((Object)this, true, reason));
    }

    public String toString() {
        return "ANDWaveformProcessWrapper(" + this.process.toString() + ")";
    }

    @Override
    public WaveformProcess getWrappedProcess() {
        return this.process;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

