/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import edu.sc.seis.sod.util.convert.wav.FissuresToWAV;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.w3c.dom.Element;

public class WavWriter
extends AbstractSeismogramWriter {
    public static final String DEFAULT_FILE_TEMPLATE = "Event_${event.getTime('yyyy_MM_dd_HH_mm_ss')}/${prefix}${channel.codes}${index}.wav";
    int speedup = 2000;
    public static final String SPEEDUP = "speedup";

    public WavWriter(String workingDir, String fileTemplate, String prefix, int speedup) throws ConfigurationException {
        super(workingDir, fileTemplate, prefix, false);
        this.speedup = speedup;
    }

    public WavWriter(Element el) throws ConfigurationException {
        this(WavWriter.extractWorkingDir(el), WavWriter.extractFileTemplate(el, DEFAULT_FILE_TEMPLATE), WavWriter.extractPrefix(el), SodUtil.loadInt(el, SPEEDUP, 2000));
    }

    @Override
    public SeismogramFileTypes getFileType() {
        return null;
    }

    @Override
    public void write(String loc, LocalSeismogramImpl seis, Channel chan, CacheEvent ev) throws Exception {
        File f = new File(loc);
        FissuresToWAV fisToWAV = new FissuresToWAV(seis, this.speedup);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
        fisToWAV.writeWAV(out, new TimeRange(seis));
        out.close();
    }
}

