/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.hibernate.UnsupportedFileTypeException;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.util.convert.mseed.FissuresConvert;
import edu.sc.seis.sod.util.convert.sac.FissuresToSac;
import edu.sc.seis.sod.util.convert.sac.SacToFissures;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;

@Deprecated
public class URLDataSetSeismogram {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalSeismogramImpl getSeismogram(File file, SeismogramFileTypes fileType) throws UnsupportedFileTypeException, FissuresException, IOException, SeedFormatException {
        if (fileType.equals(SeismogramFileTypes.MSEED)) {
            FilterInputStream dis = null;
            ArrayList<DataRecord> list = new ArrayList<DataRecord>();
            try {
                try {
                    dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    while (true) {
                        SeedRecord sr;
                        if (!((sr = SeedRecord.read((DataInput)((Object)dis), (int)4096)) instanceof DataRecord)) {
                            continue;
                        }
                        list.add((DataRecord)sr);
                    }
                }
                catch (EOFException eOFException) {
                    if (dis != null) {
                        dis.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (dis != null) {
                    dis.close();
                }
                throw throwable;
            }
            return FissuresConvert.toFissures(list.toArray(new DataRecord[0]), (byte)10, (byte)1);
        }
        if (SeismogramFileTypes.SAC.equals(fileType)) {
            SacTimeSeries sacTime;
            try (FilterInputStream dis = null;){
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                sacTime = SacTimeSeries.read((DataInput)((Object)dis));
            }
            return SacToFissures.getSeismogram(sacTime);
        }
        throw new UnsupportedFileTypeException("File type " + fileType.getName() + " is not supported");
    }

    public static File saveAsSac(LocalSeismogramImpl seis, File directory) throws IOException, CodecException {
        try {
            return URLDataSetSeismogram.saveAsSac(seis, directory, null, null);
        }
        catch (NoPreferredOrigin noPreferredOrigin) {
            return null;
        }
    }

    public static File saveAs(LocalSeismogramImpl seis, File directory, Channel channel, CacheEvent event, SeismogramFileTypes saveFileType) throws IOException, NoPreferredOrigin, CodecException, UnsupportedFileTypeException, SeedFormatException {
        if (saveFileType.equals(SeismogramFileTypes.SAC)) {
            return URLDataSetSeismogram.saveAsSac(seis, directory, channel, event);
        }
        if (saveFileType.equals(SeismogramFileTypes.MSEED)) {
            return URLDataSetSeismogram.saveAsMSeed(seis, directory, channel, event);
        }
        throw new UnsupportedFileTypeException("Unsupported File Type " + saveFileType.getName());
    }

    public static File getUnusedFileName(File directory, Channel channel, String suffix) {
        File seisFile = URLDataSetSeismogram.getBaseFile(directory, channel, suffix);
        int n = 1;
        while (seisFile.exists()) {
            seisFile = URLDataSetSeismogram.makeFile(directory, n, channel, suffix);
            ++n;
        }
        return seisFile;
    }

    public static File getBaseFile(File directory, Channel channel, String suffix) {
        return URLDataSetSeismogram.makeFile(directory, 0, channel, suffix);
    }

    public static File makeFile(File directory, int count, Channel channel, String suffix) {
        Object seisFilename = ChannelIdUtil.toStringNoDates(channel);
        seisFilename = (String)seisFilename + (String)(count > 0 ? "" + count : "");
        seisFilename = ((String)seisFilename).replace(' ', '_');
        seisFilename = (String)seisFilename + suffix;
        return new File(directory, (String)seisFilename);
    }

    public static File saveAsMSeed(LocalSeismogramImpl seis, File directory, Channel channel, CacheEvent event) throws IOException, SeedFormatException {
        File seisFile = URLDataSetSeismogram.getUnusedFileName(directory, channel, ".mseed");
        return URLDataSetSeismogram.writeMSeed(seis, seisFile);
    }

    public static File writeMSeed(LocalSeismogramImpl seis, File seisFile) throws SeedFormatException, FileNotFoundException, IOException {
        DataRecord[] dr = FissuresConvert.toMSeed(seis);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(seisFile)));
        for (int i = 0; i < dr.length; ++i) {
            dr[i].write(dos);
        }
        dos.close();
        return seisFile;
    }

    public static File saveAsSac(LocalSeismogramImpl seis, File directory, Channel channel, CacheEvent event) throws IOException, NoPreferredOrigin, CodecException {
        File seisFile = URLDataSetSeismogram.getUnusedFileName(directory, channel, ".sac");
        SacTimeSeries sac = FissuresToSac.getSAC(seis, channel, event != null ? event.get_preferred_origin() : null);
        sac.write(seisFile);
        return seisFile;
    }
}

