/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.sac.SacPoleZero;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.bag.Transfer;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.util.convert.sac.StationXMLToSacPoleZero;
import edu.sc.seis.sod.util.convert.stationxml.StationXMLToFissures;
import org.w3c.dom.Element;

public class TransferResponse
implements WaveformProcess,
Threadable {
    float lowCut;
    float lowPass;
    float highPass;
    float highCut;
    public static final float DEFAULT_LOW_CUT = 0.005f;
    public static final float DEFAULT_LOW_PASS = 0.01f;
    public static final float DEFAULT_HIGH_PASS = 100000.0f;
    public static final float DEFAULT_HIGH_CUT = 1000000.0f;

    public TransferResponse(Element config) throws ConfigurationException {
        this.lowCut = DOMHelper.extractFloat(config, "lowCut", 0.005f);
        this.lowPass = DOMHelper.extractFloat(config, "lowPass", 0.01f);
        this.highPass = DOMHelper.extractFloat(config, "highPass", 100000.0f);
        this.highCut = DOMHelper.extractFloat(config, "highCut", 1000000.0f);
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        try {
            LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
            NetworkSource na = Start.getNetworkArm().getNetworkSource();
            if (seismograms.length > 0) {
                SacPoleZero polezero = TransferResponse.checkResponse(channel, na);
                Transfer transfer = new Transfer();
                for (int i = 0; i < seismograms.length; ++i) {
                    out[i] = transfer.apply(seismograms[i], polezero, this.lowCut, this.lowPass, this.highPass, this.highCut);
                }
                return new WaveformResult(out, new StringTreeLeaf(this, true));
            }
            return new WaveformResult(true, seismograms, this);
        }
        catch (InvalidResponse e) {
            return new WaveformResult(seismograms, new Fail((Object)this, e.getMessage()));
        }
    }

    public static SacPoleZero checkResponse(Channel chan, NetworkSource na) throws InvalidResponse, SodSourceException, UnknownUnit {
        try {
            Response response = na.getResponse(chan);
            if (response == null) {
                throw new InvalidResponse("Response is null");
            }
            Response.checkResponse((Response)response);
            if (!(response.getFirstStage().getResponseItem() instanceof PolesZeros)) {
                throw new InvalidResponse("First Stage is not PolesZeros: " + ((ResponseStage)response.getResponseStageList().get(0)).getResponseItem().getClass().getSimpleName());
            }
            PolesZeros polesZeros = (PolesZeros)response.getFirstStage().getResponseItem();
            UnitImpl inUnits = StationXMLToFissures.convertUnit(polesZeros.getInputUnits());
            if (!(inUnits.isConvertableTo(UnitImpl.METER) || inUnits.isConvertableTo(UnitImpl.METER_PER_SECOND) || inUnits.isConvertableTo(UnitImpl.METER_PER_SECOND_PER_SECOND))) {
                throw new InvalidResponse("Response input units are not convertible to m, m/s or m/s/s, cannot apply correction." + String.valueOf(inUnits));
            }
            try {
                return StationXMLToSacPoleZero.convert(response);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidResponse(e.getMessage(), (Throwable)e);
            }
        }
        catch (ChannelNotFound e) {
            throw new InvalidResponse("No instrumentation found", (Throwable)e);
        }
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

