/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import org.w3c.dom.Element;

public class Taper
implements WaveformProcess,
Threadable {
    edu.sc.seis.sod.bag.Taper taper;

    public Taper(Element config) {
        Element widthElement;
        int type = edu.sc.seis.sod.bag.Taper.HANNING;
        Element typeElement = SodUtil.getElement(config, "type");
        if (typeElement != null) {
            String typeStr = SodUtil.getText(typeElement);
            if (typeStr.equals("hanning")) {
                type = edu.sc.seis.sod.bag.Taper.HANNING;
            } else if (typeStr.equals("hamming")) {
                type = edu.sc.seis.sod.bag.Taper.HANNING;
            } else if (typeStr.equals("cosine")) {
                type = edu.sc.seis.sod.bag.Taper.COSINE;
            }
        }
        if ((widthElement = SodUtil.getElement(config, "width")) != null) {
            float width = Float.parseFloat(SodUtil.getText(widthElement));
            this.taper = new edu.sc.seis.sod.bag.Taper(type, width);
        } else {
            this.taper = new edu.sc.seis.sod.bag.Taper(type);
        }
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        for (int i = 0; i < seismograms.length; ++i) {
            out[i] = this.taper.apply(seismograms[i]);
        }
        return new WaveformResult(out, new StringTreeLeaf(this, true));
    }
}

