/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.process.waveform.ResultWrapper;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeBranch;
import org.w3c.dom.Element;

public class RetryAndContinue
extends ResultWrapper {
    private SodDB sodDb;

    public RetryAndContinue(Element config) throws ConfigurationException {
        super(config);
    }

    public String toString() {
        return "RetryAndContinue(" + this.subprocess.toString() + ")";
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        WaveformResult result;
        if (this.sodDb == null) {
            this.sodDb = SodDB.getSingleton();
        }
        if (!(result = this.subprocess.accept(event, channel, original, available, seismograms, cookieJar)).isSuccess()) {
            cookieJar.getECP().update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.RETRY));
            return this.wrapResult(result);
        }
        return result;
    }

    protected WaveformResult wrapResult(WaveformResult result) {
        return new WaveformResult(result.getSeismograms(), new StringTreeBranch((Object)this, true, result.getReason()));
    }
}

