/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTreeLeaf;
import java.time.Instant;

public class ResponseGain
implements WaveformProcess,
Threadable {
    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        if (seismograms.length > 0) {
            InstrumentSensitivity sensitivity;
            NetworkSource na = Start.getNetworkArm().getNetworkSource();
            InstrumentSensitivity instrumentSensitivity = sensitivity = channel.getResponse() == null ? null : channel.getResponse().getInstrumentSensitivity();
            if (sensitivity == null) {
                return new WaveformResult(out, new StringTreeLeaf(this, false, "No instrumentation found for time " + TimeUtils.toISOString((Instant)seismograms[0].begin_time)));
            }
            for (int i = 0; i < seismograms.length; ++i) {
                out[i] = edu.sc.seis.sod.bag.ResponseGain.apply(seismograms[i], sensitivity);
            }
            return new WaveformResult(out, new StringTreeLeaf(this, true));
        }
        return new WaveformResult(true, seismograms, this);
    }
}

