/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.velocity.PrintlineVelocitizer;
import java.io.IOException;
import org.w3c.dom.Element;

public class PrintlineSeismogramProcess
implements WaveformProcess {
    private PrintlineVelocitizer velocitizer;
    private String template;
    private String filename;
    public static final String DEFAULT_TEMPLATE = "Got $seismograms.size() seismograms for $channel.toString() for eq on $event.time";

    public PrintlineSeismogramProcess(Element config) throws ConfigurationException {
        this.filename = DOMHelper.extractText(config, "filename", "");
        this.template = DOMHelper.extractText(config, "template", DEFAULT_TEMPLATE);
        this.velocitizer = new PrintlineVelocitizer(new String[]{this.filename, this.template});
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws IOException {
        this.velocitizer.evaluate(this.filename, this.template, event, channel, original, available, seismograms, cookieJar);
        return new WaveformResult(seismograms, new StringTreeLeaf(this, true));
    }
}

