/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.requestGenerator.PhaseRequest;
import edu.sc.seis.sod.util.time.CoverageTool;
import org.w3c.dom.Element;

public class PhaseDataCoverage
implements WaveformProcess {
    private PhaseRequest phaseRequest;

    public PhaseDataCoverage(Element config) throws ConfigurationException {
        this.phaseRequest = new PhaseRequest(config);
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        RequestFilter req = this.phaseRequest.generateRequest(event, channel);
        RequestFilter[] uncovered = CoverageTool.notCovered(new RequestFilter[]{req}, seismograms);
        return new WaveformResult(seismograms, new StringTreeLeaf(this, uncovered.length == 0));
    }
}

