/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.bag.Cut;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.requestGenerator.PhaseRequest;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PhaseCut
implements WaveformProcess {
    Element config;
    PhaseRequest phaseRequest;
    private static Logger logger = LoggerFactory.getLogger((String)PhaseRequest.class.getName());

    public PhaseCut(Element config) throws ConfigurationException {
        this.config = config;
        this.phaseRequest = new PhaseRequest(config);
    }

    public PhaseCut(PhaseRequest phaseRequest) throws ConfigurationException {
        this.phaseRequest = phaseRequest;
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        LocalSeismogramImpl[] cutSeis;
        RequestFilter[] cutRequest = this.phaseRequest.generateRequest(event, channel, cookieJar);
        return new WaveformResult(cutSeis, new StringTreeLeaf(this, (cutSeis = PhaseCut.cut(seismograms, cutRequest)).length != 0));
    }

    public static LocalSeismogramImpl[] cut(LocalSeismogramImpl[] seismograms, RequestFilter[] cuts) throws FissuresException {
        LinkedList<LocalSeismogramImpl> cutSeis = new LinkedList<LocalSeismogramImpl>();
        for (int i = 0; i < cuts.length; ++i) {
            Cut cut = new Cut(cuts[i].startTime, cuts[i].endTime);
            for (int j = 0; j < seismograms.length; ++j) {
                LocalSeismogramImpl tempSeis = cut.apply(seismograms[j]);
                if (tempSeis == null) continue;
                cutSeis.add(tempSeis);
            }
        }
        return cutSeis.toArray(new LocalSeismogramImpl[0]);
    }
}

