/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.measure.ArrayMeasurement;
import edu.sc.seis.sod.measure.Measurement;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.AbstractWaveformMeasure;
import org.w3c.dom.Element;

public class OregonDspFFT
extends AbstractWaveformMeasure {
    public OregonDspFFT(Element config) {
        super(config);
    }

    @Override
    Measurement calculate(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        if (seismograms.length != 1) {
            throw new Exception("Require continuous data, but num seismograms=" + seismograms.length);
        }
        return new ArrayMeasurement(this.getName(), OregonDspFFT.forward(seismograms[0].get_as_floats()));
    }

    public static float[] forward(float[] realData) {
        return edu.sc.seis.sod.bag.OregonDspFFT.forward(realData);
    }

    public static float[] inverse(float[] realData) {
        return edu.sc.seis.sod.bag.OregonDspFFT.inverse(realData);
    }

    public static float[] correlate(float[] x, float[] y) {
        return edu.sc.seis.sod.bag.OregonDspFFT.correlate(x, y);
    }

    public static float[] convolve(float[] x, float[] y, float delta) {
        return edu.sc.seis.sod.bag.OregonDspFFT.convolve(x, y, delta);
    }
}

