/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import edu.sc.seis.sod.process.waveform.URLDataSetSeismogram;
import java.io.File;
import org.w3c.dom.Element;

public class MseedWriter
extends AbstractSeismogramWriter {
    public static final String DEFAULT_FILE_TEMPLATE = "Event_${event.getTime('yyyy_MM_dd_HH_mm_ss')}/${prefix}${channel.codes}${index}.mseed";

    public MseedWriter(Element el) throws ConfigurationException {
        super(MseedWriter.extractWorkingDir(el), MseedWriter.extractFileTemplate(el, DEFAULT_FILE_TEMPLATE), MseedWriter.extractPrefix(el), DOMHelper.hasElement(el, "storeSeismogramsInDB"));
    }

    @Override
    public void write(String loc, LocalSeismogramImpl seis, Channel chan, CacheEvent ev) throws Exception {
        AbstractSeismogramWriter.addBytesWritten(URLDataSetSeismogram.writeMSeed(seis, new File(loc)).length());
    }

    @Override
    public SeismogramFileTypes getFileType() {
        return SeismogramFileTypes.MSEED;
    }
}

