/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.TimeSeriesDataSel;
import edu.sc.seis.sod.process.waveform.FillStyle;
import edu.sc.seis.sod.process.waveform.GapFill;

class LinearFill
extends FillStyle {
    LinearFill() {
    }

    @Override
    public TimeSeriesDataSel fill(LocalSeismogramImpl first, LocalSeismogramImpl second) throws FissuresException {
        TimeSeriesDataSel outHolder = new TimeSeriesDataSel();
        int numGapPoints = GapFill.calcNumGapPoints(first, second);
        if (first.can_convert_to_long()) {
            int firstEndSample = first.get_as_longs()[first.getNumPoints() - 1];
            int secondBeginSample = second.get_as_longs()[0];
            int[] out = new int[numGapPoints];
            for (int i = 0; i < out.length; ++i) {
                out[i] = Math.round((float)firstEndSample + (float)(secondBeginSample - firstEndSample) * ((float)i + 1.0f) / (float)(numGapPoints + 1));
            }
            outHolder.int_values(out);
        } else if (first.can_convert_to_float()) {
            float firstEndSample = first.get_as_floats()[first.getNumPoints() - 1];
            float secondBeginSample = second.get_as_floats()[0];
            float[] out = new float[numGapPoints];
            for (int i = 0; i < out.length; ++i) {
                out[i] = firstEndSample + (secondBeginSample - firstEndSample) * ((float)i + 1.0f) / (float)(numGapPoints + 1);
            }
            outHolder.flt_values(out);
        } else {
            double firstEndSample = first.get_as_doubles()[first.getNumPoints() - 1];
            double secondBeginSample = second.get_as_doubles()[0];
            double[] out = new double[numGapPoints];
            for (int i = 0; i < out.length; ++i) {
                out[i] = firstEndSample + (secondBeginSample - firstEndSample) * (double)((float)i + 1.0f) / (double)(numGapPoints + 1);
            }
            outHolder.dbl_values(out);
        }
        return outHolder;
    }
}

