/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.bag.Cut;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.TimeSeriesDataSel;
import edu.sc.seis.sod.process.waveform.FillStyle;
import edu.sc.seis.sod.process.waveform.LinearFill;
import edu.sc.seis.sod.process.waveform.Merge;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.process.waveform.ZeroFill;
import edu.sc.seis.sod.util.time.ReduceTool;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class GapFill
extends Merge {
    FillStyle filler;
    private static final Logger logger = LoggerFactory.getLogger(GapFill.class);

    public GapFill(Element config) {
        if (DOMHelper.hasElement(config, "zeroFill")) {
            this.filler = new ZeroFill();
        } else if (DOMHelper.hasElement(config, "linearFill")) {
            this.filler = new LinearFill();
        }
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        int i;
        WaveformResult merged = super.accept(event, channel, original, available, Cut.cutOverlap(seismograms), cookieJar);
        List<LocalSeismogramImpl> sortedSeismograms = new ArrayList<LocalSeismogramImpl>();
        for (i = 0; i < merged.getSeismograms().length; ++i) {
            sortedSeismograms.add(merged.getSeismograms()[i]);
        }
        Collections.sort(sortedSeismograms, new Comparator<LocalSeismogramImpl>(){

            @Override
            public int compare(LocalSeismogramImpl o1, LocalSeismogramImpl o2) {
                if (o1.getBeginTime().isBefore(o2.getBeginTime())) {
                    return -1;
                }
                if (o1.getBeginTime().isAfter(o2.getBeginTime())) {
                    return 1;
                }
                return 0;
            }
        });
        for (i = 0; i < original.length; ++i) {
            TimeRange mstr = new TimeRange(original[i]);
            sortedSeismograms = this.reduce(sortedSeismograms, mstr);
        }
        return new WaveformResult(true, sortedSeismograms.toArray(new LocalSeismogramImpl[0]), this);
    }

    public List<LocalSeismogramImpl> reduce(List<LocalSeismogramImpl> inList, TimeRange mstr) throws FissuresException {
        if (inList.size() == 0 || inList.size() == 1) {
            return inList;
        }
        LocalSeismogramImpl first = inList.remove(0);
        List<LocalSeismogramImpl> remaining = this.reduce(inList, mstr);
        LocalSeismogramImpl second = remaining.remove(0);
        LinkedList<LocalSeismogramImpl> outList = new LinkedList<LocalSeismogramImpl>();
        if (mstr.contains(first.getEndTime()) && mstr.contains(second.getBeginTime())) {
            LocalSeismogramImpl[] merged = this.gapFill(first, second);
            for (int i = 0; i < merged.length; ++i) {
                outList.add(merged[i]);
            }
        } else {
            outList.add(first);
            outList.add(second);
        }
        outList.addAll(remaining);
        return outList;
    }

    public LocalSeismogramImpl[] gapFill(LocalSeismogramImpl first, LocalSeismogramImpl second) throws FissuresException {
        TimeSeriesDataSel fillData = this.filler.fill(first, second);
        LocalSeismogramImpl fillSeis = new LocalSeismogramImpl(first.get_id() + "_gapFill", first.getProperties(), first.getEndTime().plus(first.getSampling().getPeriod()), GapFill.calcNumGapPoints(first, second), first.getSampling(), first.getUnit(), first.getChannelID(), first.getParameterRefs(), fillData);
        LocalSeismogramImpl[] merged = ReduceTool.merge(new LocalSeismogramImpl[]{first, fillSeis, second});
        return merged;
    }

    public static int calcNumGapPoints(LocalSeismogramImpl first, LocalSeismogramImpl second) {
        Instant firstEnd = first.getEndTime();
        Instant secondBegin = second.getBeginTime();
        double numSamplePeriods = TimeUtils.durationToDoubleSeconds((Duration)Duration.between(firstEnd, secondBegin.minus(first.getSampling().getPeriod().dividedBy(2L)))) / TimeUtils.durationToDoubleSeconds((Duration)first.getSampling().getPeriod());
        return (int)Math.ceil(numSamplePeriods) - 1;
    }
}

