/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.RequestFilterUtil;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.util.time.CoverageTool;
import org.w3c.dom.Element;

public class FullDataCoverage
implements WaveformProcess {
    public FullDataCoverage() {
    }

    public FullDataCoverage(Element config) {
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) {
        if (seismograms.length == 0) {
            return new WaveformResult(seismograms, new StringTreeLeaf(this, false, "No seismograms"));
        }
        RequestFilter[] notCovered = CoverageTool.notCovered(original, seismograms);
        if ((notCovered = RequestFilterUtil.removeSmallRequests(notCovered, seismograms[0].getSampling().getPeriod())).length == 0) {
            String reason = "Data returned completly covers the request";
            return new WaveformResult(seismograms, new StringTreeLeaf(this, true, reason));
        }
        String reason = "Data does not cover " + notCovered.length + " sections of the request. ";
        for (int i = 0; i < notCovered.length; ++i) {
            reason = reason + notCovered[i].startTime.toString() + " to " + notCovered[i].endTime.toString() + ",  ";
        }
        return new WaveformResult(seismograms, new StringTreeLeaf(this, false, reason));
    }
}

